package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenKind;

public class Eq {

	public static void run(SharedFields sf, Class type, String name)
			throws Exception {

		if (sf.tokenArray.getVal(sf.index).equals(sf.targetName)) {
			// sl
			sf.index++;
			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, sf.target);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			sf.target.putUndefValue(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
		} else if (sf.tokenArray.getVal(sf.index).equals(
				sf.target.getClassName())) {
			// sl
			sf.index++;
			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.staticRun(sf, undefV, sf.target);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			sf.target.putUndefValue(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
		} else if (isUndefVal(sf)) {
			// slslĂ΂
			UndefinedValue targetUndef = (UndefinedValue) sf.vt
					.getVal(sf.tokenArray.getVal(sf.index));

			sf.index++;

			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, targetUndef);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			targetUndef.putUndefValue(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);

		} else if (isCastTarget(sf)) {
			// LXg𖳎
			// sl
			sf.index++;// (
			sf.index++;// somethingClass
			sf.index++;// )
			sf.index++;//

			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, sf.target);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			sf.target.putUndefValue(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
		} else if (isCastUndefVal(sf)) {
			// slslĂ΂
			// LXg𖳎
			// sl
			sf.index++;// (
			sf.index++;// somethingClass
			sf.index++;// )

			UndefinedValue targetUndef = (UndefinedValue) sf.vt
					.getVal(sf.tokenArray.getVal(sf.index));

			sf.index++;

			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, targetUndef);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			targetUndef.putUndefValue(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);

		} else {
			Expression.run(sf);
			Object o = sf.valueStack.pop();
			sf.typeStack.pop();

			if (o instanceof TargetClass) {
				TargetClass tempTarget = (TargetClass) o;
				UndefinedValue undefV = (UndefinedValue) sf.valueStack.pop();
				sf.typeStack.pop();
				tempTarget.putUndefValue(name, undefV);
				sf.vt.setValAndLevel(name, undefV, sf.currentLevel);

				tempTarget.overWriteMethodReType(
						sf.lastCallintTargetMethodName, LangMgn
								.getClassName(type));

			} else {

				// byte,short̏ꍇAinteger^Ă܂̂
				// Ŏ~߂
				// byte b =1; ̏ꍇAnew Integet(1)Ă܂B
				o = SmallInterpreterSupportor.toByteOrShort(type, o);

				sf.vt.setValAndLevel(name, o, sf.currentLevel);
			}
		}
	}

	private static boolean isCastTarget(SharedFields sf) {
		return sf.tokenArray.getVal(sf.index).equals("(")
				&& sf.tokenArray.getVal(sf.index + 3).equals(sf.targetName);
	}

	private static boolean isCastUndefVal(SharedFields sf) {
		if (sf.tokenArray.getVal(sf.index).equals("(")) {
			Token t = sf.tokenArray.get(sf.index + 3);
			if (t.getKind() == TokenKind.Word) {
				if (sf.vt.include(t.getVal())) {
					return sf.vt.getVal(t.getVal()).getClass() == UndefinedValue.class;
				}
			}
		}
		return false;
	}

	private static boolean isUndefVal(SharedFields sf) {
		Token t = sf.tokenArray.get(sf.index);
		if (t.getKind() == TokenKind.Word) {
			if (sf.vt.include(t.getVal())) {
				return sf.vt.getVal(t.getVal()).getClass() == UndefinedValue.class;
			}
		}
		return false;
	}

}
