/*
 * Created on 2005/02/19
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.mock.analysis;

import org.kikaineko.mock.analysis.exception.CannotAnalyzeSyntaxForKikainekoMockerException;
import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

/**
 * TestCasẽg[N󂯎ATestClassTarget𐶐
 * 
 * @author masayuki
 * 
 */
public class TestAnalyst implements Analyst {
	protected TokenArray ta;

	protected TestClass tc;

	protected TargetClass target;
	
	private String instancedMethodName;

	/**
	 * @param tokeArrayWithoutComment
	 */
	public TestAnalyst(TokenArray inTa) {
		this.ta = inTa;
	}

	public void analyze() throws Exception {
		setTestClass();
		setTargetClass();

		ignoreConstructor();

		setUpForAnalyze();
		setSetUp();
		setTestMethod();
		setTearDown();
		setMethods();
		setFields();
		
		retrySetTargetClass();
		
		tearDownForAnalyze();
	}

	/**
	 * targetClass̃RXgN^擾
	 * setTargetClassŎ擾łĂꍇA邢͂ǂĂ擾łȂꍇ
	 * instancedMethodNamenullɂȂĂB
	 * Ȃ݂ɁAbJ[̎dlŋ[NX͓2ȏCX^X݂邱Ƃ͋ȂB
	 * ܂A^[QbgϐȊOɋ[NXCX^XĂ͂Ȃ̂
	 * RXgN^͕K^[Qbgϐɑ΂đ邱ƂɂȂB
	 * ̐𗘗pāARXgN^SɌB
	 * 
	 * ŁAretryŎŝ́AeXgP[X̂Ȃɂ̃\bh̕ԂlŃCX^XĂ\邽߂łB
	 * ̏ꍇAL̐ACX^X͕K return new HogeConst();
	 * ̂悤ɂȂĂB
	 * iȂȂA[ϐȊOɃCX^X͂łȂA[ϐɑ΂ĒڃCX^XĂ΂͎̉͂sȂj
	 * 
	 * A̎_ł̉͂ł͌ȃRXgN^̎擾͂łȂBȂȂႦ
	 * target = get();
	 * ƏĂꍇAget\bhreturn newƂg[NTɂǍオmɗ~RXgN^ǂ͕ۏ؂łȂB
	 * ɒ[ȘbAreturn new ObjectƏĂĂʂ͂ȂB
	 * ɁAgetƂÕ\bhꍇB
	 * ǈxRpC邩A]Ȃ͌ɂ͎擾łȂB
	 * 
	 * ̂߁A@BLbJ[ł͂Ȃׂׂ
	 * target = new Hoge();
	 * ƏƂ𐄏B
	 *
	 */
	private void retrySetTargetClass() {
		if(instancedMethodName==null){
			return;
		}
		for(int i=0;i<tc.howManyMethodsInTestCase();i++){
			if(tc.getMethodInTestCase(i).getName().equals(instancedMethodName)){
				TokenArray temp=tc.getMethodInTestCase(i).getTokenArray();
				int index=temp.indexOfVal("return","new");
				target.setClassName(temp.getVal(index+2));
				return;
			}
		}
	}

	private void ignoreConstructor() {
		int start = getIndexOfConstructor();
		while (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen,
					TokenKind.BlockClose);
			ta.takeSubArray(start, end + 1);
			start = getIndexOfConstructor();
		}
	}

	private int getIndexOfConstructor() {
		int start = -1;
		do {
			start = ta.indexOfVal(tc.getClassName(), "(", start + 1);
			if (start != -1) {
				if (start != 0) {
					if (ta.getVal(start - 1).equals("public")
							|| ta.getVal(start - 1).equals("private")
							|| ta.getVal(start - 1).equals("protected"))
						start -= 1;
				}
				return start;

			}
		} while (start != -1);
		return -1;
	}

	protected void setUpForAnalyze() {
	}

	private void setMethods() {
		if (ta.length() == 0) {
			return;
		}
		int start = indexOfMethodInTestCase();
		while (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen,
					TokenKind.BlockClose);
			addMethod(ta.takeSubArray(start, end + 1));
			start = indexOfMethodInTestCase();
		}
	}

	private void addMethod(TokenArray arr) {
		tc.addMethod(arr);
	}

	private int indexOfMethodInTestCase() {
		int ii = ta.indexOfVal("private");
		while (ii != -1) {
			for (int i = ii + 1; i < ta.length(); i++) {
				int k = ta.getKind(i);
				if (k != TokenKind.Word) {
					if (k == TokenKind.OpenKakko) {
						return ii;
					} else if (k == TokenKind.Piriod) {
					} else {
						ii = ta.indexOfVal("private", ii + 1);
						if (ii == -1) {
							return -1;
						} else {
							i = ii + 1;
						}
					}
				}
			}
		}
		return -1;
	}

	protected void tearDownForAnalyze() throws Exception {
		checkbJ[@();
	}

	private void setFields() {
		if (ta.length() == 0) {
			return;
		}
		ta.deleteThisVal("private");
		ta.deleteThisVal("public");
		ta.deleteThisVal("protected");
		ta.deleteThisVal("static");
		ta.deleteThisVal("transient");
		ta.deleteThisVal("final");
		Token t = new Token(TokenKind.CloseKakko, "}");
		ta.pushToken(t);
		if (ta.get(0).getKind() == TokenKind.Eq) {
			t = new Token(TokenKind.Word, target.getInstanceName());
			ta.insertIntoFirstToken(t);
		}
		tc.setFieldsPart(ta);
	}

	protected void checkbJ[@() throws Exception {
		int index=ta.indexOfVal("{");
		while(index!=-1){
			if(index==0)
				throw new CannotAnalyzeSyntaxForKikainekoMockerException(ta
						.getToken(index).getLineNo(), ta.getVal(index));
			int kind=ta.getKind(index-1);
			if(!(kind==TokenKind.Eq || kind==TokenKind.BlockOpen)){
				throw new CannotAnalyzeSyntaxForKikainekoMockerException(ta
						.getToken(index).getLineNo(), ta.getVal(index));
			}
			index=ta.indexOfVal("{",index+1);
		}
	}

	/**
	 * 
	 */
	private void setSetUp() {
		int start = getIndexOfSetUp();
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen,
					TokenKind.BlockClose);
			tc.setSetUp(ta.takeSubArray(start, end + 1));
		} else {
			// setUpI[o[ChȂꍇ
			// ftHg̉ȂeXgP[XĂ
			tc.setSetUp(new TokenArray("{}"));
		}
	}

	protected int getIndexOfSetUp() {
		int i = ta.indexOfVal("protected", "void", "setUp");
		if (i >= 0) {
			return i;
		}

		return ta.indexOfVal("public", "void", "setUp");
	}

	/**
	 * 
	 */
	private void setTearDown() {
		int start = getIndexOfTearDown();
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen,
					TokenKind.BlockClose);
			tc.setTearDown(ta.takeSubArray(start, end + 1));
		} else {
			// tearDownI[o[ChȂꍇ
			// ftHg̉ȂeXgP[XĂ
			tc.setTearDown(new TokenArray("{}"));
		}
	}

	protected int getIndexOfTearDown() {
		int i = ta.indexOfVal("protected", "void", "tearDown");
		if (i >= 0) {
			return i;
		}

		return ta.indexOfVal("public", "void", "tearDown");
	}

	private void setTestMethod() {
		int start = getIndexOfTestMethod();
		while (start != -1) {
			int end = getIndexOfClosed(ta, start, TokenKind.BlockOpen,
					TokenKind.BlockClose);
			tc.addTestMethod(ta.takeSubArray(start, end + 1));
			start = getIndexOfTestMethod();
		}
	}

	protected int getIndexOfTestMethod() {
		int start = -1;
		do {
			start = ta.indexOfVal("public", "void", start + 1);
			if (start != -1 && ta.getVal(start + 2).startsWith("test"))
				return start;
		} while (start != -1);
		return -1;
	}

	protected int getIndexOfClosed(TokenArray arr, int start, int opK, int clK) {
		int count = 0;
		for (int i = start; i < arr.length(); i++) {
			if (arr.getKind(i) == opK)
				count++;
			else if (arr.getKind(i) == clK) {
				count--;
				if (count == 0)
					return i;
			}
		}
		return -1;
	}

	/**
	 * @return
	 */
	protected void setTestClass() throws Exception {

		String pack = getPackage();

		Import[] im = getImports();

		int index = ta.indexOfVal("class");
		String name = ta.getVal(index + 1);

		index = ta.indexOfVal("extends");
		if (ta.getVal(index + 1).indexOf("TestCase") == -1) {
			throw new NotTestCaseException("This class is not TestCase : "
					+ name);
		}
		tc = new TestClass(pack, name);
		tc.setImports(im);

		ta = ta.takeSubArray(ta.indexOfVal("{", index) + 1, getIndexOfClosed(
				ta, index, TokenKind.BlockOpen, TokenKind.BlockClose));
	}

	private String getPackage() {
		int index = ta.indexOfVal("package");
		if (index == -1) {
			// ftHgpbP[W
			return "";
		}
		int endindex = ta.indexOfVal(";", index);
		StringBuffer sb = new StringBuffer();
		for (int i = index + 1; i < endindex; i++) {
			sb.append(ta.getVal(i));
		}
		return sb.toString();
	}

	protected Import[] getImports() {
		int num = ta.howManyOfVal("import");
		Import[] im = new Import[num];
		for (int i = 0; i < im.length; i++) {
			int from = ta.indexOfVal("import");
			int end = ta.indexOfVal(";", from);
			im[i] = new Import(ta.takeSubArray(from, end + 1));
		}
		return im;

	}

	/**
	 * @return
	 */
	protected void setTargetClass() throws Exception {
		int index = ta.indexOfKind(TokenKind.Word);
		while (LangMgn.isReserved(ta.getVal(index))) {
			index++;
		}
		target = new TargetClass(ta.getVal(index), ta.getVal(index + 1));

		target.setPack(tc.packageName());
		if (ta.getVal(index + 2).equals(";")) {
			ta = ta.takeSubArray(index + 3);
		} else if (ta.getVal(index + 2).equals("=")
				&& ta.getVal(index + 3).equals("null")
				&& ta.getVal(index + 4).equals(";")) {
			ta = ta.takeSubArray(index + 5);
		} else {
			ta = ta.takeSubArray(index + 2);
		}

		index = ta.indexOfVal(target.getInstanceName(), "=", "new");
		if (index != -1) {
			target.setClassName(ta.getVal(index + 3));
		} else {
			index = ta.indexOfVal(target.getInstanceName(), "=");
			if(index!=-1){
				instancedMethodName=ta.getVal(index+2);
			}
		}
	}

	public TargetClass getTargetClass() {
		return target;
	}

	/**
	 * @return
	 */
	public TestClass getTestClass() {
		return tc;
	}

}