package org.kikaineko.mock.analysis;

import java.util.Stack;

import org.kikaineko.mock.analysis.exception.CannotUseUndefValueException;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.Operator;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class SmallInterpreterSupportor {
	public static String getErrorMessage(TokenArray tokenArray, int index) {
		String message = "";
		if (index >= 2)
			message = tokenArray.getVal(index - 2) + " "
					+ tokenArray.getVal(index - 1) + " "
					+ tokenArray.getVal(index);
		else if (index >= 1)
			message = tokenArray.getVal(index - 1) + " "
					+ tokenArray.getVal(index);
		else
			message = tokenArray.getVal(index);
		return message;
	}

	public static Object getIncOrDec(Object o, String ope)
			throws CannotUseUndefValueException {

		if (o.getClass() == Byte.class) {
			return Operator.operate(new Byte((byte) 1), o, ope);
		} else if (o.getClass() == Short.class) {
			return Operator.operate(new Short((short) 1), o, ope);
		} else if (o instanceof UndefinedValue) {
			throw new CannotUseUndefValueException();
		} else {
			return Operator.operate(new Integer(1), o, ope);
		}
	}

	public static void negatePush(Stack valueStack, Object o)
			throws CannotUseUndefValueException {
		if (o instanceof Integer)
			valueStack.push(new Integer(-((Integer) o).intValue()));
		else if (o instanceof Byte)
			valueStack.push(new Byte((byte) -((Byte) o).byteValue()));
		else if (o instanceof Short)
			valueStack.push(new Short((short) -((Short) o).shortValue()));
		else if (o instanceof Long)
			valueStack.push(new Long(-((Long) o).longValue()));
		else if (o instanceof Float)
			valueStack.push(new Float(-((Float) o).floatValue()));
		else if (o instanceof Double)
			valueStack.push(new Double(-((Double) o).doubleValue()));
		else if (o instanceof Boolean)
			valueStack.push(new Boolean(!((Boolean) o).booleanValue()));
		else if (o instanceof UndefinedValue)
			throw new CannotUseUndefValueException();
	}

	public static void operation(Stack valueStack, TypeOwner typeStack,
			String ope) throws CannotUseUndefValueException {
		Object o1 = valueStack.pop();
		Object o2 = valueStack.pop();

		if ((o1 instanceof UndefinedValue) || (o2 instanceof UndefinedValue)) {
			throw new CannotUseUndefValueException();
		}

		valueStack.push(Operator.operate(o1, o2, ope));
		typeStack.push(Operator.strongType((Class) typeStack.pop(),
				(Class) typeStack.pop()));
	}

	public static boolean isVariable(ClassNameResolver classNameResolver,
			String s) {
		if (LangMgn.isPremit(s)) {
			return true;
		}
		Class c = classNameResolver.getClazz(s);
		return c != null;
	}

	public static String getMethodSignature(Class[] argsClasses, String name) {
		StringBuffer sb = new StringBuffer();
		sb.append(name);
		sb.append("(");
		if (argsClasses != null) {
			for (int i = 0; i < argsClasses.length; i++) {
				sb.append(argsClasses[i].getName());
				sb.append(" ");
			}
		}
		sb.append(")");
		return sb.toString();
	}

	public static Object toByteOrShort(Class type, Object o)
			throws CannotUseUndefValueException {
		// ̃\bhbyteshort̏ꍇ̕␳̂ߕsl邱Ƃz肷Kv
		if (type == byte.class) {
			return new Byte(((Integer) o).byteValue());
		} else if (type == short.class) {
			return new Short(((Integer) o).shortValue());
		}
		return o;
	}

	public static int numberPush(Token t, TokenArray tokenArray, int index,
			Stack valueStack, TypeOwner typeStack) {
		String s = tokenArray.getVal(index);
		if (s.equals("l") || s.equals("L")) {
			index++;
			valueStack.push(new Long(t.getVal()));
			typeStack.push(long.class);
		} else if (s.equals("d") || s.equals("D")) {
			index++;
			valueStack.push(new Double(t.getVal()));
			typeStack.push(double.class);
		} else if (s.equals("f") || s.equals("F")) {
			index++;
			valueStack.push(new Float(t.getVal()));
			typeStack.push(float.class);
		} else if (s.equals(".")) {
			return afterPiriodPush(t, tokenArray, index, valueStack, typeStack);
		} else if (t.getKind() == TokenKind.Piriod) {
			return afterPiriodPush(new Token(TokenKind.Number, "0"),
					tokenArray, index - 1, valueStack, typeStack);
		} else {
			valueStack.push(new Integer(t.getVal()));
			typeStack.push(int.class);
		}

		return index;
	}

	private static int afterPiriodPush(Token t, TokenArray tokenArray,
			int index, Stack valueStack, TypeOwner typeStack) {
		index++;
		Token tt = tokenArray.getToken(index);
		Token tt2 = tokenArray.getToken(index + 1);
		if (tt.getKind() == TokenKind.Number) {
			if (tt2.getVal().equals("f") || tt2.getVal().equals("F")) {
				index = index + 2;
				valueStack.push(new Float(t.getVal() + "." + tt.getVal()));
				typeStack.push(float.class);
			} else if (tt2.getVal().equals("d") || tt2.getVal().equals("D")) {
				index = index + 2;
				valueStack.push(new Double(t.getVal() + "." + tt.getVal()));
				typeStack.push(double.class);
			} else {
				index++;
				valueStack.push(new Double(t.getVal() + "." + tt.getVal()));
				typeStack.push(double.class);
			}
		} else if (tt.getVal().equals("f") || tt.getVal().equals("F")) {
			// float ff=1.f;̂悤ȏꍇ
			index++;// f΂
			index++;
			valueStack.push(new Float(t.getVal() + "." + tt.getVal()));
			typeStack.push(float.class);
		} else {
			// double dd=1.d;̂悤ȏꍇ
			index++;// d΂
			valueStack.push(new Double(t.getVal()));
			typeStack.push(double.class);
		}

		return index;
	}

	public static char toCharFromString(String s) {
		if (s.length() == 1)
			return s.charAt(0);
		if (s.length() > 1) {
			if (s.charAt(0) == '\\') {
				char c = s.charAt(1);
				// b,t,n,f,r,
				if (c == 'b')
					return '\b';
				else if (c == 't')
					return '\t';
				else if (c == 'n')
					return '\n';
				else if (c == 'f')
					return '\f';
				else if (c == 'r')
					return '\r';
				return c;
			}
		}
		return (char) -1;
	}
}
