/*
 * 쐬F 2005/03/29
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;

import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.ImportForJUnit4;
import org.kikaineko.mock.runner.KikainekoClassLoaderWrapper;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.util.StringMgn;

/**
 * NX̖OClassNXԂB <br>
 * 
 * ႦStringƂOjava.lang.String.classԂB <br>
 * NX[_Ƃ̈Ⴂ́ANX[_pbP[W܂ފSȖOKvƂ̂ɑ΂ ͊SȖOKvƂȂB
 * ^ꂽOɑ΂AeXgP[X̃pbP[WEC|[gꂽNXƔr Oł̂ɑ΂ăNXԂB
 * 
 * @author Masayuki Ioki
 */
public class ClassNameResolver {
	private Import[] ims;

	private String packageName;

	private Hashtable cash;

	private Hashtable staticImportsCash = null;

	/**
	 * 
	 */
	public ClassNameResolver(String pack, Import[] ims) {
		this.packageName = pack;
		this.ims = ims;
		cash = new Hashtable();
	}

	/**
	 * ^ꂽNXNX[hł邩𔻒肷. JgXbh̃ReLXgNX[_烍[hB
	 * 
	 */
	private Class load(String fullClassName) {
		ClassLoader cl = Thread.currentThread().getContextClassLoader();
		Class cz = null;
		try {
			cz = cl.loadClass(fullClassName);
		} catch (Exception e) {
		} catch (Error e) {
		}

		return cz;
	}

	/**
	 * ^ꂽNXNX[hł邩𔻒肷. @BLNX[_烍[hB
	 * 
	 */
	private Class custumLoad(String fullClassName) {
		Class cz = null;
		try {
			cz = KikainekoClassLoaderWrapper.loadClass(fullClassName);
		} catch (Exception e) {
		} catch (Error e) {
		}

		return cz;
	}

	/**
	 * ^ꂽNXA1ǉz̃NXԂB
	 * 
	 */
	public static Class getArrayClass(Class clazz) {
		Object o = Array.newInstance(clazz, 0);
		return o.getClass();
	}

	/**
	 * ^ꂽnameƈvClassԂB <br>
	 * Ⴆ΁AnameStringȂAjava.lang.StringNXԂB
	 * 
	 * @param name
	 * @return
	 */
	public Class getClazz(String name) {
		Class c = (Class) cash.get(name);
		if (c != null) {
			return c;
		}
		c = defaultResolve(name);
		if (c == null) {
			c = custumResolve(name);
		}
		if (c == null)
			c = getClassForArray(name);
		
		if (c != null){
			cash.put(name, c);
			//tl[łꉞLbVĂ
			cash.put(c.getName(), c);
		}
		return c;
	}

	/**
	 * int[][] ƂONX int[][].classԂ
	 * 
	 * @param name
	 * @return
	 */
	private Class getClassForArray(String name) {
		int count = StringMgn.count(name, "[");
		if (count == 0) {
			return null;
		}
		name = name.substring(0,name.indexOf("["));
		Class c = getClazz(name);
		for (int i = 0; i < count; i++) {
			c = getArrayClass(c);
		}
		return c;
	}

	/**
	 * ʏ̃[hŖOłȂꍇ̃[h KikainekoClassLoadergp
	 * 
	 * @param name
	 * @return
	 */
	private Class custumResolve(String name) {
		Class c = null;

		Vector fullClassNames = getListFullClassNames(name);

		for (int i = 0; i < fullClassNames.size(); i++) {
			c = custumLoad((String) fullClassNames.get(i));
			if (c != null)
				return c;
		}

		return null;
	}

	private Class defaultResolve(String name) {
		try {
			Class c = Class.forName(name);
			return c;
		} catch (Exception e) {
		}
		if (LangMgn.isPremit(name)) {
			return LangMgn.getPremitClass(name);
		}

		Class c = null;

		Vector fullClassNames = getListFullClassNames(name);

		for (int i = 0; i < fullClassNames.size(); i++) {
			c = load((String) fullClassNames.get(i));
			if (c != null)
				return c;
		}

		return null;
	}

	/**
	 * NX̃tl[A܂pbP[W܂񂾖Ǒ擾
	 * 
	 * @param string
	 * @return
	 */
	public Vector getListFullClassNames(String name) {
		Vector fullNames = new Vector();
		for (int i = 0; i < ims.length; i++) {
			String tn = ims[i].getClassNmae();
			if (tn.equals(name)) {
				// ӂɓł̂ŁA͂Ȃ
				fullNames = new Vector();
				fullNames.add(ims[i].getPackageName() + name);
				return fullNames;
			} else if (tn.equals("*")) {
				fullNames.add(ims[i].getPackageName() + name);
			}
		}
		fullNames.add(packageName + "." + name);
		fullNames.add("java.lang." + name);
		return fullNames;
	}

	public boolean isStaticImport(String val) {
		if (staticImportsCash == null) {
			initStaticImportCash();
		}
		return staticImportsCash.containsKey(val);
	}

	private void initStaticImportCash() {
		staticImportsCash = new Hashtable();
		for (int i = 0; i < ims.length; i++) {
			if (ims[i].getClass() == ImportForJUnit4.class) {
				String part = ((ImportForJUnit4) ims[i]).staticPart();
				if (part.equals("*")) {
					Class c = getClazz(ims[i].getClassNmae());
					// JUnit4JUnit3ŃG~[gĂ֌W
					// org.junit.AssertȂǂȂB
					// {nullɂȂ邱Ƃُ͈킾AL̗RnullĂ܂
					if (c != null) {
						Method[] ms = c.getMethods();
						for (int k = 0; k < ms.length; k++) {
							if (Modifier.isStatic(ms[k].getModifiers())) {
								staticImportsCash.put(ms[k].getName(), c);
							}
						}
						Field[] fs = c.getFields();
						for (int k = 0; k < fs.length; k++) {
							if (Modifier.isStatic(fs[k].getModifiers())) {
								staticImportsCash.put(fs[k].getName(), c);
							}
						}
					}
				} else {
					Class c = getClazz(ims[i].getClassNmae());
					if (c != null)
						staticImportsCash.put(part, c);
				}
			}
		}
	}

	public Class getClassByStaticImportPartName(String val) {
		if (staticImportsCash == null) {
			initStaticImportCash();
		}
		return (Class) staticImportsCash.get(val);
	}
	
	/**
	 * łɃ[hꂽǂ𒲂ׂ
	 * @param clazz
	 * @return
	 */
	protected boolean hasClazz(String clazz){
		return cash.containsKey(clazz);
	}

}