/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.plugin.logics;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.kikaineko.mock.analysis.NotTestCaseException;
import org.kikaineko.mock.plugin.utils.MockerUtils;
import org.kikaineko.mock.runner.BaseRunner;
import org.kikaineko.mock.runner.InvalidPathException;
import org.kikaineko.mock.runner.KikainekoClassLoaderWithPaths;
import org.kikaineko.mock.runner.KikainekoClassLoaderWrapper;
import org.kikaineko.mock.runner.Path;

public class MockGenerateRunnable
implements IRunnableWithProgress {
    private IPath filePath = null;
    private IProject project = null;

    public MockGenerateRunnable(IPath filePath, IProject project) {
        this.filePath = filePath;
        this.project = project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Creating mock file...", 5);
        try {
            Path[] pathArray = this.getPathArray();
            KikainekoClassLoaderWithPaths kikainekoClassLoaderWithPaths = new KikainekoClassLoaderWithPaths(pathArray);
            KikainekoClassLoaderWrapper.setClassLoader((ClassLoader)kikainekoClassLoaderWithPaths);
        }
        catch (InvalidPathException e) {
            throw new InterruptedException(e.toString());
        }
        catch (JavaModelException e) {
            throw new InterruptedException(e.toString());
        }
        String fileName = this.getOSFileName();
        BaseRunner runner = new BaseRunner();
        String mockCode = null;
        try {
            mockCode = runner.doRun(new File(fileName)).toString();
        }
        catch (NotTestCaseException e) {
            MessageDialog.openInformation((Shell)new Shell(), (String)"kikainekoMocker \u30d7\u30e9\u30b0\u30a4\u30f3", (String)"\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u3067\u306f\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f\u3002");
            throw new InterruptedException(e.toString());
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        String mockFileName = runner.targetFile().getName();
        monitor.worked(1);
        IPath newFilePath = this.filePath.removeLastSegments(1).append(mockFileName);
        IFile newFile = MockerUtils.getNewFile(newFilePath);
        monitor.worked(1);
        System.out.println("Already exists? : " + newFile.exists());
        if (newFile.exists()) {
            boolean ans = MessageDialog.openQuestion((Shell)new Shell(), (String)"kikainekoMocker \u30d7\u30e9\u30b0\u30a4\u30f3", (String)(String.valueOf(newFile.getName()) + "\u306f\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f\n\uff08\u73fe\u5728\u306e\u30b3\u30fc\u30c9\u306f\u30b3\u30e1\u30f3\u30c8\u30a2\u30a6\u30c8\u3055\u308c\u3066\u4fdd\u6301\u3055\u308c\u307e\u3059\u3002\uff09"));
            if (!ans) throw new InterruptedException();
            try {
                newFile.delete(true, null);
            }
            catch (CoreException e) {
                throw new InterruptedException(e.toString());
            }
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(mockCode.getBytes());
        monitor.worked(1);
        try {
            try {
                newFile.create((InputStream)stream, true, monitor);
            }
            catch (CoreException e) {
                throw new InterruptedException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_18 = null;
        }
        monitor.done();
    }

    private Path[] getPathArray() throws InvalidPathException, JavaModelException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        if (javaProject != null) {
            Path path;
            String pathString;
            String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3) {
                    pathString = String.valueOf(workspacePath) + entries[i].getPath().toString();
                    System.out.println("CPE_SOURCE : " + pathString);
                } else if (entries[i].getEntryKind() == 1) {
                    pathString = entries[i].getPath().toString();
                    System.out.println("CPE_LIBRARY : " + pathString);
                    path = new Path(pathString, 2);
                    pathList.add(path);
                }
                ++i;
            }
            IPath outputPath = javaProject.getOutputLocation();
            pathString = String.valueOf(workspacePath) + outputPath.toString();
            System.out.println("OUTPUT_LOCATION : " + pathString);
            path = new Path(pathString, 0);
            pathList.add(path);
        }
        Path[] pathArray = new Path[pathList.size()];
        int i = 0;
        while (i < pathList.size()) {
            pathArray[i] = (Path)pathList.get(i);
            ++i;
        }
        return pathArray;
    }

    private String getOSFileName() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.filePath).getLocation().toOSString();
    }
}

