/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.sourcescan;

import org.kikaineko.source.util.Token;

public class CommentAutomaton {
    public static final int LineCommentStart = 0;
    public static final int InComment = 1;
    public static final int OutComment = -1;
    public static final int CommentStart = 2;
    public static final int CommentClose = 3;
    public static final int StringStart = 4;
    public static final int StringEnd = 5;
    public static final int InString = 6;
    public static final int CharStart = 7;
    public static final int CharEnd = 8;
    public static final int InChar = 9;
    private int state = -1;

    public int state(Token token) {
        int kind = token.getKind();
        if (this.state == -1) {
            this.outComment(kind);
        } else if (this.state == 2) {
            this.commentStart(kind);
        } else if (this.state == 1) {
            this.inComment(kind);
        } else if (this.state == 4) {
            this.stringStart(kind);
        } else if (this.state == 6) {
            this.inString(kind);
        } else if (this.state == 7) {
            this.charStart(kind);
        } else if (this.state == 9) {
            this.inChar(kind);
        } else {
            this.state = this.findState(kind);
        }
        return this.state;
    }

    private void outComment(int kind) {
        this.state = this.findState(kind);
    }

    private void commentStart(int kind) {
        this.state = kind == 51 ? 3 : 1;
    }

    private void inComment(int kind) {
        if (kind == 51) {
            this.state = 3;
        }
    }

    private void stringStart(int kind) {
        this.state = kind == 16 ? 5 : 6;
    }

    private void inString(int kind) {
        if (kind == 16) {
            this.state = 5;
        }
    }

    private void charStart(int kind) {
        this.state = kind == 17 ? 8 : 9;
    }

    private void inChar(int kind) {
        if (kind == 17) {
            this.state = 8;
        }
    }

    private int findState(int kind) {
        if (kind == 52) {
            return 0;
        }
        if (kind == 50) {
            return 2;
        }
        if (kind == 16) {
            return 4;
        }
        if (kind == 17) {
            return 7;
        }
        return -1;
    }

    public boolean isStateComment() {
        if (this.state == 2) {
            return true;
        }
        if (this.state == 1) {
            return true;
        }
        return this.state == 3;
    }

    public boolean isLiteral() {
        if (this.state == 5) {
            return true;
        }
        if (this.state == 4) {
            return true;
        }
        if (this.state == 6) {
            return true;
        }
        if (this.state == 8) {
            return true;
        }
        if (this.state == 7) {
            return true;
        }
        return this.state == 9;
    }
}

