/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.sourcescan;

import java.io.File;
import junit.framework.TestCase;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.sourcescan.CodeReader;

public class CodeReaderTest
extends TestCase {
    CodeReader cr;

    protected void setUp() throws Exception {
        super.setUp();
        this.cr = new CodeReader(new File("src\\fortest\\TestReaderTestTest.java"));
    }

    public void testGetLinesWithoutComment() {
        TokenArray ta = this.cr.getTokenArrayWithoutComment();
        CodeReaderTest.assertEquals((String)"package", (String)ta.getVal(0));
        CodeReaderTest.assertEquals((boolean)false, (boolean)ta.get((int)0).isLiteral);
        int len = ta.length();
        CodeReaderTest.assertEquals((String)"}", (String)ta.getVal(len - 1));
        CodeReaderTest.assertEquals((String)"}", (String)ta.getVal(len - 2));
        CodeReaderTest.assertEquals((String)";", (String)ta.getVal(len - 3));
    }

    public void testGetTokensWithoutComment() {
        Token[] ts = this.cr.getTokensWithoutComment("\" ad \"/* hoge */ package org.kikaineko.analysis;");
        CodeReaderTest.assertEquals((String)" ad ", (String)ts[1].getVal());
        CodeReaderTest.assertEquals((boolean)true, (boolean)ts[1].isLiteral);
        CodeReaderTest.assertEquals((String)"package", (String)ts[3].getVal());
        ts = this.cr.getTokensWithoutComment("package org.kikaineko.analysis;/* hoge */ ");
        CodeReaderTest.assertEquals((String)"package", (String)ts[0].getVal());
        ts = this.cr.getTokensWithoutComment("package org.kikaineko.analysis/* hoge */;");
        CodeReaderTest.assertEquals((String)"package", (String)ts[0].getVal());
    }

    public void testGetTokensWithoutCommentOpenAndClose() {
        Token[] ts = this.cr.getTokensWithoutComment("package org.kikaineko./* analysis;");
        CodeReaderTest.assertEquals((String)"package", (String)ts[0].getVal());
        CodeReaderTest.assertEquals((int)5, (int)ts.length);
        ts = this.cr.getTokensWithoutComment("package \" dafa \"org.kikaineko./* analysis;");
        CodeReaderTest.assertEquals((int)0, (int)ts.length);
        ts = this.cr.getTokensWithoutComment("package org.kikaineko.*/ analysis;");
        CodeReaderTest.assertEquals((String)"analysis", (String)ts[0].getVal());
        ts = this.cr.getTokensWithoutComment("package org.kikaineko./* analysis;");
        ts = this.cr.getTokensWithoutComment("package org.kikaineko. analysis;*/");
        CodeReaderTest.assertEquals((int)0, (int)ts.length);
    }

    public void testGetTokensWithoutLineComment() {
        Token[] ts = this.cr.getTokensWithoutComment("package org.kikaineko.//analysis;");
        CodeReaderTest.assertEquals((String)"package", (String)ts[0].getVal());
        CodeReaderTest.assertEquals((int)5, (int)ts.length);
        ts = this.cr.getTokensWithoutComment("package org.kikaineko.analysis;");
        CodeReaderTest.assertEquals((int)7, (int)ts.length);
    }
}

