/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.source.util;

import junit.framework.TestCase;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.sourcescan.Tokenizer;

public class TokenArrayTest
extends TestCase {
    TokenArray ta;
    Token[] ts;

    protected void setUp() throws Exception {
        super.setUp();
        Tokenizer tkn = new Tokenizer("p=1+2,1");
        this.ts = tkn.getTokens();
        this.ta = new TokenArray(this.ts);
    }

    public void test\u6587\u5b57\u5217\u5f15\u6570\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3082\u8a31\u3059\u3088() {
        TokenArray tokenArray = new TokenArray("p=1+2,1");
        TokenArrayTest.assertEquals((int)0, (int)tokenArray.howManyOfVal("0"));
        TokenArrayTest.assertEquals((int)1, (int)tokenArray.howManyOfVal("p"));
    }

    public void testHowManyOfVal() {
        TokenArrayTest.assertEquals((int)0, (int)this.ta.howManyOfVal("0"));
        TokenArrayTest.assertEquals((int)1, (int)this.ta.howManyOfVal("p"));
        TokenArrayTest.assertEquals((int)2, (int)this.ta.howManyOfVal("1"));
    }

    public void testAddArray() {
        this.ta = new TokenArray();
        Tokenizer ts1 = new Tokenizer("p=1+2,1");
        TokenArrayTest.assertEquals((int)0, (int)this.ta.length());
        this.ta.addArray(ts1.getTokens());
        ts1 = new Tokenizer("p=1+2,1");
        TokenArrayTest.assertEquals((int)7, (int)this.ta.length());
        this.ta.addArray(ts1.getTokens());
        TokenArrayTest.assertEquals((int)14, (int)this.ta.length());
        TokenArrayTest.assertEquals((String)"1", (String)this.ta.getVal(13));
        int i = 0;
        while (i < 10) {
            this.ta.addArray(new Tokenizer("p=1+2,1").getTokens());
            ++i;
        }
        TokenArrayTest.assertEquals((int)84, (int)this.ta.length());
        TokenArrayTest.assertEquals((String)"1", (String)this.ta.getVal(13));
        TokenArrayTest.assertEquals((String)"1", (String)this.ta.getVal(83));
        i = 0;
        while (i < 10) {
            this.ta.addArray(new Tokenizer("p=1+2,1").getTokens());
            ++i;
        }
        TokenArrayTest.assertEquals((int)154, (int)this.ta.length());
        TokenArrayTest.assertEquals((String)"1", (String)this.ta.getVal(13));
        TokenArrayTest.assertEquals((String)"1", (String)this.ta.getVal(153));
    }

    public void testLength() {
        TokenArrayTest.assertEquals((int)7, (int)this.ta.length());
    }

    public void testStaticHowManyOfKind() {
        TokenArrayTest.assertEquals((int)1, (int)TokenArray.howManyOfKind(this.ts, 4));
        TokenArrayTest.assertEquals((int)3, (int)TokenArray.howManyOfKind(this.ts, 1));
    }

    public void testStaticIndexOfKind() {
        TokenArrayTest.assertEquals((int)0, (int)TokenArray.indexOfKind(this.ts, 4));
        TokenArrayTest.assertEquals((int)-1, (int)TokenArray.indexOfKind(this.ts, 4, 2));
    }

    public void testStaticIndexOfVal() {
        TokenArrayTest.assertEquals((int)0, (int)TokenArray.indexOfVal(this.ts, "p"));
        TokenArrayTest.assertEquals((int)-1, (int)TokenArray.indexOfVal(this.ts, "p", 2));
    }

    public void testStaticSubArray() {
        TokenArrayTest.assertEquals((int)4, (int)TokenArray.subArray(this.ts, 1, 5).length);
        TokenArrayTest.assertEquals((int)6, (int)TokenArray.subArray(this.ts, 1).length);
    }

    public void testStaticRemoveArray() {
        TokenArrayTest.assertEquals((int)3, (int)TokenArray.removeArray(this.ts, 1, 5).length);
        TokenArrayTest.assertEquals((String)"p", (String)TokenArray.removeArray(this.ts, 1, 5)[0].getVal());
        TokenArrayTest.assertEquals((String)",", (String)TokenArray.removeArray(this.ts, 1, 5)[1].getVal());
        TokenArrayTest.assertEquals((String)"1", (String)TokenArray.removeArray(this.ts, 1, 5)[2].getVal());
        TokenArrayTest.assertEquals((int)1, (int)TokenArray.removeArray(this.ts, 1).length);
    }

    public void testIndexOfKind() {
        TokenArrayTest.assertEquals((int)0, (int)this.ta.indexOfKind(4));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfKind(6));
        TokenArrayTest.assertEquals((int)1, (int)this.ta.indexOfKind(5));
        TokenArrayTest.assertEquals((int)2, (int)this.ta.indexOfKind(1));
        TokenArrayTest.assertEquals((int)2, (int)this.ta.indexOfKind(1, 1));
        TokenArrayTest.assertEquals((int)2, (int)this.ta.indexOfKind(1, 2));
        TokenArrayTest.assertEquals((int)4, (int)this.ta.indexOfKind(1, 3));
    }

    public void testIndexOfVal() {
        TokenArrayTest.assertEquals((int)0, (int)this.ta.indexOfVal("p"));
        TokenArrayTest.assertEquals((int)2, (int)this.ta.indexOfVal("1"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("pi"));
        TokenArrayTest.assertEquals((int)6, (int)this.ta.indexOfVal("1", 4));
    }

    public void testIndexOfVal2() {
        Tokenizer tkn = new Tokenizer("p=1+2,1-n+1k");
        this.ts = tkn.getTokens();
        this.ta = new TokenArray(this.ts);
        TokenArrayTest.assertEquals((int)0, (int)this.ta.indexOfVal("p", "="));
        TokenArrayTest.assertEquals((int)6, (int)this.ta.indexOfVal("1", "-"));
        TokenArrayTest.assertEquals((int)10, (int)this.ta.indexOfVal("1", "k"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("j", "k"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("-", "k"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("k", "k"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("j", "u"));
    }

    public void testIndexOfVal3() {
        Tokenizer tkn = new Tokenizer("p=1+2,1-n+1k");
        this.ts = tkn.getTokens();
        this.ta = new TokenArray(this.ts);
        TokenArrayTest.assertEquals((int)0, (int)this.ta.indexOfVal("p", "=", "1"));
        TokenArrayTest.assertEquals((int)6, (int)this.ta.indexOfVal("1", "-", "n"));
        TokenArrayTest.assertEquals((int)9, (int)this.ta.indexOfVal("+", "1", "k"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("1", "k", "k"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("j", "k", "l"));
        TokenArrayTest.assertEquals((int)-1, (int)this.ta.indexOfVal("p", "k", "1"));
    }

    public void testGet() {
        TokenArrayTest.assertEquals((String)"p", (String)this.ta.get(0).getVal());
        TokenArrayTest.assertEquals((String)"p", (String)this.ta.getVal(0));
        TokenArrayTest.assertEquals((boolean)false, (boolean)this.ta.isLiteral(0));
        TokenArrayTest.assertEquals((int)4, (int)this.ta.getKind(0));
        Token t = this.ta.get(0);
        t = null;
        TokenArrayTest.assertNull((Object)t);
        TokenArrayTest.assertEquals((String)"p", (String)this.ta.get(0).getVal());
        this.ts[0] = null;
        TokenArrayTest.assertNull((Object)this.ts[0]);
        TokenArrayTest.assertEquals((String)"p", (String)this.ta.get(0).getVal());
    }

    public void testSubArray() {
        TokenArray ta2 = this.ta.subArray(1, 5);
        TokenArrayTest.assertEquals((int)4, (int)ta2.length());
        TokenArrayTest.assertEquals((String)"=", (String)ta2.getVal(0));
        TokenArrayTest.assertEquals((String)"2", (String)ta2.getVal(3));
        ta2 = this.ta.subArray(1);
        TokenArrayTest.assertEquals((int)6, (int)ta2.length());
        TokenArrayTest.assertEquals((String)"=", (String)ta2.getVal(0));
        TokenArrayTest.assertEquals((String)"2", (String)ta2.getVal(3));
        TokenArrayTest.assertEquals((String)"1", (String)ta2.getVal(5));
    }

    public void testTakeSubArray() {
        TokenArrayTest.assertEquals((String)"p = 1 + 2 , 1 ", (String)this.ta.toString());
        TokenArrayTest.assertEquals((int)7, (int)this.ta.length());
        TokenArray ta2 = this.ta.takeSubArray(1, 5);
        TokenArrayTest.assertEquals((int)4, (int)ta2.length());
        TokenArrayTest.assertEquals((int)3, (int)this.ta.length());
        TokenArrayTest.assertEquals((String)"=", (String)ta2.getVal(0));
        TokenArrayTest.assertEquals((String)"2", (String)ta2.getVal(3));
        TokenArrayTest.assertEquals((String)"p , 1 ", (String)this.ta.toString());
        TokenArrayTest.assertEquals((String)"= 1 + 2 ", (String)ta2.toString());
    }

    public void testTakeSubArray2() {
        TokenArrayTest.assertEquals((String)"p = 1 + 2 , 1 ", (String)this.ta.toString());
        TokenArrayTest.assertEquals((int)7, (int)this.ta.length());
        TokenArray ta2 = this.ta.takeSubArray(1);
        TokenArrayTest.assertEquals((int)6, (int)ta2.length());
        TokenArrayTest.assertEquals((int)1, (int)this.ta.length());
        System.out.println(this.ta);
        System.out.println(ta2);
        TokenArrayTest.assertEquals((String)"p ", (String)this.ta.toString());
        TokenArrayTest.assertEquals((String)"= 1 + 2 , 1 ", (String)ta2.toString());
    }
}

