/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.source.util;

import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.Tokenizer;

public class TokenArray {
    private Token[] tokens;
    private int addLength = 50;
    private int length;

    public TokenArray(Token[] ts) {
        this.tokens = new Token[ts.length];
        this.length = ts.length;
        System.arraycopy(ts, 0, this.tokens, 0, this.tokens.length);
    }

    public TokenArray(String context) {
        Token[] ts = new Tokenizer(context).getTokens();
        this.tokens = new Token[ts.length];
        this.length = ts.length;
        System.arraycopy(ts, 0, this.tokens, 0, this.tokens.length);
    }

    public TokenArray() {
        this.tokens = new Token[this.addLength];
        this.length = 0;
    }

    public int length() {
        return this.length;
    }

    public int indexOfKind(int kind) {
        return this.indexOfKind(kind, 0);
    }

    public int indexOfKind(int kind, int fromIndex) {
        int i = fromIndex;
        while (i < this.length()) {
            if (this.tokens[i].getKind() == kind && !this.tokens[i].isLiteral) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfVal(String string) {
        return this.indexOfVal(string, 0);
    }

    public int indexOfVal(String string, int fromIndex) {
        int i = fromIndex;
        while (i < this.length()) {
            if (this.tokens[i].getVal().equals(string) && !this.tokens[i].isLiteral) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Token get(int i) {
        return this.tokens[i];
    }

    public String getVal(int i) {
        return this.get(i).getVal();
    }

    public int getKind(int i) {
        return this.get(i).getKind();
    }

    public TokenArray subArray(int from, int end) {
        Token[] tt = new Token[end - from];
        System.arraycopy(this.tokens, from, tt, 0, tt.length);
        return new TokenArray(tt);
    }

    public TokenArray subArray(int from) {
        return this.subArray(from, this.length());
    }

    public static int indexOfKind(Token[] ts, int kind) {
        return TokenArray.indexOfKind(ts, kind, 0);
    }

    public static int indexOfKind(Token[] ts, int kind, int from) {
        int i = from;
        while (i < ts.length) {
            if (ts[i].getKind() == kind && !ts[i].isLiteral) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfVal(Token[] ts, String val) {
        return TokenArray.indexOfVal(ts, val, 0);
    }

    public static int indexOfVal(Token[] ts, String val, int from) {
        int i = from;
        while (i < ts.length) {
            if (ts[i].getVal().equals(val) && !ts[i].isLiteral) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Token[] subArray(Token[] ts, int from, int end) {
        Token[] tt = new Token[end - from];
        System.arraycopy(ts, from, tt, 0, tt.length);
        return tt;
    }

    public static Token[] subArray(Token[] ts, int from) {
        return TokenArray.subArray(ts, from, ts.length);
    }

    public static Token[] removeArray(Token[] ts, int from, int end) {
        Token[] tt = new Token[ts.length - end + from];
        System.arraycopy(ts, 0, tt, 0, from);
        System.arraycopy(ts, end, tt, from, tt.length - from);
        return tt;
    }

    public static Token[] removeArray(Token[] ts, int from) {
        Token[] tt = new Token[from];
        System.arraycopy(ts, 0, tt, 0, from);
        return tt;
    }

    public void addArray(Token[] ts) {
        if (ts.length == 0) {
            return;
        }
        if (this.tokens.length > ts.length + this.length()) {
            System.arraycopy(ts, 0, this.tokens, this.length(), ts.length);
            this.length += ts.length;
        } else {
            Token[] ts2 = new Token[this.tokens.length];
            System.arraycopy(this.tokens, 0, ts2, 0, this.tokens.length);
            this.tokens = new Token[ts2.length + this.addLength];
            System.arraycopy(ts2, 0, this.tokens, 0, ts2.length);
            this.addArray(ts);
        }
    }

    public boolean isLiteral(int i) {
        return this.get((int)i).isLiteral;
    }

    public static int howManyOfKind(Token[] ts, int kind) {
        int index = -1;
        int num = -1;
        do {
            ++num;
        } while ((index = TokenArray.indexOfKind(ts, kind, index + 1)) != -1);
        return num;
    }

    public int indexOfVal(String string, String string2) {
        return this.indexOfVal(string, string2, 0);
    }

    public int indexOfVal(String string, String string2, int ind) {
        int index = ind - 1;
        do {
            if ((index = this.indexOfVal(string, index + 1)) != -1 && index != this.length() - 1) continue;
            return -1;
        } while (!this.getVal(index + 1).equals(string2));
        return index;
    }

    public int indexOfVal(String string, String string2, String string3) {
        int index = -1;
        do {
            if ((index = this.indexOfVal(string, string2, index + 1)) != -1 && index < this.length() - 2) continue;
            return -1;
        } while (!this.getVal(index + 1).equals(string2));
        return index;
    }

    public TokenArray takeSubArray(int from, int to) {
        TokenArray ta = this.subArray(from, to);
        this.length = this.length() + from - to;
        this.tokens = TokenArray.removeArray(this.tokens, from, to);
        return ta;
    }

    public TokenArray takeSubArray(int from) {
        return this.takeSubArray(from, this.length());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.length()) {
            sb.append(this.tokens[i].getVal());
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public int howManyOfVal(String val) {
        int index = -1;
        int num = -1;
        do {
            ++num;
        } while ((index = this.indexOfVal(val, index + 1)) != -1);
        return num;
    }

    public Token getToken(int i) {
        return this.tokens[i];
    }
}

