/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.util;

import fortest.Kara;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.Vector;
import junit.framework.TestCase;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.Token;
import org.kikaineko.util.FileIO;
import temp.HogeToken;
import temp.TokenChild;

public class ToStringerTest
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBufferedWriter\u306f\u5185\u90e8\u3067\u5faa\u74b0\u53c2\u7167\u3092\u6301\u3063\u3066\u3044\u308b\u304c\u305d\u308c\u304c\u7121\u9650\u30eb\u30fc\u30d7\u306b\u843d\u3061\u305a\u898b\u4e8b\u6587\u5b57\u5217\u3092\u53d6\u5f97\u3067\u304d\u308b\u304b() {
        BufferedWriter b = new BufferedWriter(new OutputStreamWriter(System.out));
        String s = ToStringer.get(b);
        FileIO.writeOutPutFile(new File("C:\\hoge1.txt"), s);
        ToStringerTest.assertFalse((boolean)s.startsWith("("));
        ToStringerTest.assertNotNull((Object)s);
    }

    public void test\u7d99\u627f\u3057\u305f\u3055\u304d\u306b\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u3042\u308b\u5834\u5408() {
        TokenChild tc = new TokenChild(1);
        String s = ToStringer.get(tc);
        ToStringerTest.assertEquals((String)"temp.TokenChild(int(1)boolean(false)int(-1)int(0)java.lang.String(99))", (String)s);
    }

    public void testVector() {
        String s = null;
        ToStringerTest.assertEquals((String)"java.lang.String(@0)", (String)ToStringer.get(s));
        Vector<Object> vec = new Vector<Object>();
        vec.add("\u6a5f\u68b0\u732b");
        vec.add("\u30c9\u30e9\u3048\u3082\u3093");
        ToStringerTest.assertEquals((String)"java.util.Vector(int(0)int(2)[Ljava.lang.Object;(java.lang.String(\u6a5f\u68b0\u732b)java.lang.String(\u30c9\u30e9\u3048\u3082\u3093)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)))", (String)ToStringer.get(vec));
        vec = new Vector();
        vec.add(new Object());
        ToStringerTest.assertEquals((String)"java.util.Vector(int(0)int(1)[Ljava.lang.Object;(java.lang.Object()java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)java.lang.Object(@0)))", (String)ToStringer.get(vec));
    }

    public void testClass() {
        ToStringerTest.assertEquals((String)"java.lang.Class(int)", (String)ToStringer.get(Integer.TYPE));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ToStringerTest.assertEquals((String)"java.lang.Class([I)", (String)ToStringer.get(clazz));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ToStringerTest.assertEquals((String)"java.lang.Class([[Ljava.lang.String;)", (String)ToStringer.get(clazz2));
    }

    public void testKara() {
        ToStringerTest.assertEquals((String)"fortest.Kara()", (String)ToStringer.get(new Kara()));
    }

    public void testArr() {
        int[] arr_i = new int[]{1, 2};
        ToStringerTest.assertEquals((String)"[I(int(1)int(2))", (String)ToStringer.get(arr_i));
        int[][] ii = new int[][]{{1, 2}, {3, 4, 5, 6}};
        ToStringerTest.assertEquals((String)"[[I([I(int(1)int(2))[I(int(3)int(4)int(5)int(6)))", (String)ToStringer.get(ii));
    }

    public void testPremit() {
        ToStringerTest.assertEquals((String)"int(1)", (String)ToStringer.get(1));
        ToStringerTest.assertEquals((String)"double(1.0)", (String)ToStringer.get(1.0));
        ToStringerTest.assertEquals((String)"long(1)", (String)ToStringer.get(1L));
        ToStringerTest.assertEquals((String)"float(1.0)", (String)ToStringer.get(1.0f));
        ToStringerTest.assertEquals((String)"boolean(true)", (String)ToStringer.get(true));
        ToStringerTest.assertEquals((String)"boolean(false)", (String)ToStringer.get(false));
        ToStringerTest.assertEquals((String)"java.lang.String(test)", (String)ToStringer.get("test"));
        ToStringerTest.assertEquals((String)("char(" + String.valueOf(99) + ")"), (String)ToStringer.get('c'));
        ToStringerTest.assertEquals((String)"char(0)", (String)ToStringer.get('\u0000'));
        ToStringerTest.assertEquals((String)"byte(1)", (String)ToStringer.get((byte)1));
        ToStringerTest.assertEquals((String)"short(1)", (String)ToStringer.get((short)1));
    }

    public void testWrap() {
        ToStringerTest.assertEquals((String)"int(1)", (String)ToStringer.get(new Integer(1)));
        ToStringerTest.assertEquals((String)"double(1.0)", (String)ToStringer.get(new Double(1.0)));
        ToStringerTest.assertEquals((String)"long(1)", (String)ToStringer.get(new Long(1L)));
        ToStringerTest.assertEquals((String)"float(1.0)", (String)ToStringer.get(new Float(1.0f)));
        ToStringerTest.assertEquals((String)"boolean(true)", (String)ToStringer.get(new Boolean(true)));
        ToStringerTest.assertEquals((String)"boolean(false)", (String)ToStringer.get(new Boolean(false)));
        ToStringerTest.assertEquals((String)("char(" + String.valueOf(99) + ")"), (String)ToStringer.get(new Character('c')));
        ToStringerTest.assertEquals((String)"char(0)", (String)ToStringer.get(new Character('\u0000')));
        ToStringerTest.assertEquals((String)"short(0)", (String)ToStringer.get(new Short(0)));
        ToStringerTest.assertEquals((String)"byte(0)", (String)ToStringer.get(new Byte(0)));
    }

    public void testObjectwithoutToString() {
        Token t = new Token(1, "2");
        ToStringerTest.assertEquals((String)"org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2))", (String)ToStringer.get(t));
        HogeToken h = new HogeToken(t);
        ToStringerTest.assertEquals((String)"temp.HogeToken(boolean(false)int(0)org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2)))", (String)ToStringer.get(h));
        t = new Token(1, "2 3");
        ToStringerTest.assertEquals((String)"org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(2 3))", (String)ToStringer.get(t));
        t = new Token(1, "(");
        ToStringerTest.assertEquals((String)"org.kikaineko.source.util.Token(boolean(false)int(1)int(0)java.lang.String(@())", (String)ToStringer.get(t));
    }

    public void testSanit() {
        String s = " ";
        ToStringerTest.assertEquals((String)"java.lang.String( )", (String)ToStringer.get(s));
        s = " ab ";
        ToStringerTest.assertEquals((String)"java.lang.String( ab )", (String)ToStringer.get(s));
        s = " ab@";
        ToStringerTest.assertEquals((String)"java.lang.String( ab@@)", (String)ToStringer.get(s));
        s = "[]";
        ToStringerTest.assertEquals((String)"java.lang.String(@[@])", (String)ToStringer.get(s));
        s = "()";
        ToStringerTest.assertEquals((String)"java.lang.String(@(@))", (String)ToStringer.get(s));
    }
}

