/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.runner;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.kikaineko.mock.runner.Path;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.util.FileIO;
import org.kikaineko.util.StringMgn;

public class ClassFileSeeker {
    private Path[] paths;
    private static final String separator = System.getProperty("file.separator");
    private static final char separatorChar = StringMgn.firstChar(separator);
    private static final char separatorCharInJar = '/';
    private static final char packagerSeparatorChar = StringMgn.firstChar(LangMgn.getPackagerSeparator());

    public ClassFileSeeker(Path[] ps) {
        this.paths = ps;
        Arrays.sort(this.paths, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Path)o1).getType() - ((Path)o2).getType();
            }
        });
    }

    public Path getPath(int i) {
        return this.paths[i];
    }

    public byte[] findBytes(String className) {
        int i = 0;
        while (i < this.paths.length) {
            if (this.paths[i].getType() == 0 || this.paths[i].getType() == 1) {
                String fullPath = this.paths[i].getRawPath();
                fullPath = String.valueOf(fullPath) + separator;
                fullPath = String.valueOf(fullPath) + className.replace(packagerSeparatorChar, separatorChar);
                File f = new File(fullPath = String.valueOf(fullPath) + LangMgn.getBinSuffix());
                if (f.exists()) {
                    return FileIO.getFileDataByBytes(f);
                }
            } else if (this.paths[i].getType() == 2) {
                try {
                    JarFile jf = new JarFile(this.paths[i].getRawPath());
                    String classNameForJar = className.replace(packagerSeparatorChar, '/');
                    JarEntry je = jf.getJarEntry(String.valueOf(classNameForJar) + LangMgn.getBinSuffix());
                    if (je != null) {
                        return FileIO.getFileDataByByteFromInputStream(jf.getInputStream(je));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }
}

