/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.sourcescan.CodeReader;

public class TestAnalystTest
extends TestCase {
    TestAnalyst ta;

    protected void setUp() throws Exception {
        super.setUp();
        this.ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\TestReaderTestTest.java")).getTokenArrayWithoutComment());
        this.ta.analyze();
    }

    public void testGetName() {
        TestClass mic = this.ta.getTestClass();
        TestAnalystTest.assertEquals((String)"fortest", (String)mic.packageName());
        TestAnalystTest.assertEquals((String)"TestReaderTestTest", (String)mic.getClassName());
        TargetClass tc = this.ta.getTargetClass();
        TestAnalystTest.assertEquals((String)"Tasu", (String)tc.getClassName());
        TestAnalystTest.assertEquals((String)"tasu", (String)tc.getInstanceName());
    }

    public void testGetSetUp() {
        TestClass tc = this.ta.getTestClass();
        TestAnalystTest.assertEquals((String)"setUp()", (String)tc.getSetUp().getName());
    }

    public void testGetTearDown() {
        TestClass tc = this.ta.getTestClass();
        TestAnalystTest.assertEquals((String)"tearDown()", (String)tc.getTearDown().getName());
    }

    public void testGetTest() {
        TestClass tc = this.ta.getTestClass();
        TestAnalystTest.assertEquals((int)2, (int)tc.howManyTestMethods());
        TestAnalystTest.assertEquals((String)"testAdd()", (String)tc.getTestMethod(0).getName());
        TestAnalystTest.assertEquals((String)"testAdd2()", (String)tc.getTestMethod(1).getName());
    }

    public void testGetImport() {
        TestClass tc = this.ta.getTestClass();
        TestAnalystTest.assertEquals((int)1, (int)tc.howManyImports());
        TestAnalystTest.assertEquals((String)"import junit . framework . TestCase ; ", (String)tc.getImport(0).toString());
    }
}

