/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import java.lang.reflect.Array;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

public class SmallInterpreterTest
extends TestCase {
    SmallInterpreter mi;
    VariableTable vt;
    TargetClass target;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    protected void setUp() throws Exception {
        super.setUp();
        LangMgn.setLang(new Java());
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\TasuTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        this.mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
        this.mi.setUpanalyze();
        this.mi.analyze(0);
        this.vt = this.mi.getVariableTable();
        this.target = this.mi.getTargetClass();
    }

    public void test\u30ad\u30e3\u30b9\u30c8() {
        SmallInterpreterTest.assertEquals(Long.TYPE, (Object)this.vt.getType("l1"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, this.vt.getVal("l1").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(-3), (Object)this.vt.getVal("l1"));
    }

    public void test\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u308b\u304b() {
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii7"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, this.vt.getVal("ii7").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(10), (Object)this.vt.getVal("ii7"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii8"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz2, this.vt.getVal("ii8").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(1), (Object)this.vt.getVal("ii8"));
    }

    public void testStatic\u30e1\u30bd\u30c3\u30c9\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u308b\u304b() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, (Object)this.vt.getType("ssss1"));
        SmallInterpreterTest.assertEquals((Object)"aho", (Object)this.vt.getVal("ssss1"));
    }

    public void testNull() {
        SmallInterpreterTest.assertEquals(null, (Object)this.vt.getVal("s2"));
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, (Object)this.vt.getType("s2"));
        SmallInterpreterTest.assertEquals((String)"ho", (String)this.vt.getValToString("s3"));
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz2, (Object)this.vt.getType("s3"));
        SmallInterpreterTest.assertEquals(null, (Object)this.vt.getVal("s4"));
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz3, (Object)this.vt.getType("s4"));
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz4, (Object)this.vt.getType("sKara"));
        SmallInterpreterTest.assertEquals((Object)"", (Object)this.vt.getVal("sKara"));
    }

    public void testMethodInvoke() {
        SmallInterpreterTest.assertEquals((String)"10", (String)this.vt.getValToString("iii7"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("iii7"));
    }

    public void testIncreDecre() {
        SmallInterpreterTest.assertEquals((String)"2", (String)this.vt.getValToString("iii2"));
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("iii3"));
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("iii4"));
        SmallInterpreterTest.assertEquals((String)"2", (String)this.vt.getValToString("iii5"));
        SmallInterpreterTest.assertEquals((String)"11", (String)this.vt.getValToString("iii10"));
        SmallInterpreterTest.assertEquals((String)"8", (String)this.vt.getValToString("iii11"));
        SmallInterpreterTest.assertEquals((String)"8", (String)this.vt.getValToString("iii12"));
    }

    public void testArray() {
        SmallInterpreterTest.assertEquals((boolean)true, (boolean)this.vt.include("iis"));
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, (Object)this.vt.getType("iis"));
        SmallInterpreterTest.assertEquals((String)"1", (String)Array.get(this.vt.getVal("iis"), 0).toString());
        SmallInterpreterTest.assertEquals((String)"aho", (String)Array.get(this.vt.getVal("sss1"), 0).toString());
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("iii1"));
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("iii1"));
        SmallInterpreterTest.assertEquals((String)"3", (String)Array.get(this.vt.getVal("iis2"), 2).toString());
        SmallInterpreterTest.assertEquals((String)"s3", (String)Array.get(this.vt.getVal("sss2"), 2).toString());
        SmallInterpreterTest.assertEquals((String)"[Ljava.lang.Object;(java.lang.String(s1)java.lang.String(s2)java.lang.String(s3))", (String)ToStringer.get(this.vt.getVal("sss2")));
        SmallInterpreterTest.assertEquals((String)"int(101)", (String)ToStringer.get(this.vt.getVal("iii13")));
    }

    public void testTarget() {
        SmallInterpreterTest.assertEquals((String)"hoge(int )", (String)this.target.getMethodName(0));
        SmallInterpreterTest.assertEquals((String)"hoge()", (String)this.target.getMethodName(1));
        SmallInterpreterTest.assertEquals((String)"hoge(int int )", (String)this.target.getMethodName(2));
        SmallInterpreterTest.assertEquals((String)"Tasu()", (String)this.target.getMethodName(3));
        SmallInterpreterTest.assertEquals((String)"add(int int )", (String)this.target.getMethodName(4));
        SmallInterpreterTest.assertEquals((int)5, (int)this.target.howManyMethods());
        SmallInterpreterTest.assertEquals((String)"hoge(int )(int(1) );hoge();hoge(int int )(int(2) int(3) );Tasu();add(int int )(int(1) int(100) );", (String)this.mi.history.toString());
        SmallInterpreterTest.assertEquals((int)1, (int)this.target.howManyHistories());
        SmallInterpreterTest.assertEquals((String)"hoge(int )(int(1) );hoge();hoge(int int )(int(2) int(3) );Tasu();add(int int )(int(1) int(100) );", (String)this.target.getHistory(0));
        SmallInterpreterTest.assertEquals((String)"int(101)", (String)this.target.getValueAtHistory(0));
        SmallInterpreterTest.assertEquals((String)"int", (String)this.target.getReturnType(4));
    }

    public void testMethod() {
        SmallInterpreterTest.assertEquals((String)"123", (String)this.vt.getValToString("ss2"));
        SmallInterpreterTest.assertEquals((String)"3", (String)this.vt.getValToString("i7"));
        SmallInterpreterTest.assertEquals((String)"2", (String)this.vt.getValToString("i8"));
        SmallInterpreterTest.assertEquals((String)"2", (String)this.vt.getValToString("i9"));
        SmallInterpreterTest.assertEquals((String)"56", (String)this.vt.getValToString("ss4"));
        SmallInterpreterTest.assertEquals((String)"10", (String)this.vt.getValToString("in"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, (Object)this.vt.getType("in"));
        SmallInterpreterTest.assertEquals((Object)new Integer(10), (Object)this.vt.getVal("in"));
        SmallInterpreterTest.assertEquals((String)"0", (String)this.vt.getValToString("i10"));
        SmallInterpreterTest.assertEquals((String)"0", (String)this.vt.getValToString("in3"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz2, (Object)this.vt.getType("in3"));
        SmallInterpreterTest.assertEquals((String)"234", (String)this.vt.getValToString("ss6"));
    }

    public void testConst() {
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("sb"));
        SmallInterpreterTest.assertEquals((String)"ab", (String)this.vt.getValToString("sb2"));
    }

    public void testVtable() {
        SmallInterpreterTest.assertEquals((boolean)true, (boolean)this.vt.include("i"));
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("i"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("i"));
        SmallInterpreterTest.assertEquals((String)"100", (String)this.vt.getValToString("j"));
        SmallInterpreterTest.assertEquals((String)"20", (String)this.vt.getValToString("hoge"));
        SmallInterpreterTest.assertEquals((String)"5", (String)this.vt.getValToString("a"));
        SmallInterpreterTest.assertEquals((String)"8", (String)this.vt.getValToString("k"));
        SmallInterpreterTest.assertEquals((String)"12", (String)this.vt.getValToString("l"));
        SmallInterpreterTest.assertEquals((String)"25", (String)this.vt.getValToString("m"));
        SmallInterpreterTest.assertEquals((String)"61", (String)this.vt.getValToString("n"));
        SmallInterpreterTest.assertEquals((String)"2", (String)this.vt.getValToString("o"));
        SmallInterpreterTest.assertEquals((String)"-1", (String)this.vt.getValToString("p"));
        SmallInterpreterTest.assertEquals((String)"-19", (String)this.vt.getValToString("q"));
        SmallInterpreterTest.assertEquals((String)"800", (String)this.vt.getValToString("r"));
        SmallInterpreterTest.assertEquals((String)"12", (String)this.vt.getValToString("s"));
        SmallInterpreterTest.assertEquals((String)"16", (String)this.vt.getValToString("t"));
        SmallInterpreterTest.assertEquals((String)"20", (String)this.vt.getValToString("u"));
        SmallInterpreterTest.assertEquals((String)"aho", (String)this.vt.getValToString("ss"));
        SmallInterpreterTest.assertEquals((String)"ahohoge", (String)this.vt.getValToString("s1"));
        SmallInterpreterTest.assertEquals((String)"10", (String)this.vt.getValToString("v"));
        SmallInterpreterTest.assertEquals((String)"-1", (String)this.vt.getValToString("w"));
        SmallInterpreterTest.assertEquals((String)"100", (String)this.vt.getValToString("x"));
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("la"));
        SmallInterpreterTest.assertEquals(Long.TYPE, (Object)this.vt.getType("la"));
        SmallInterpreterTest.assertEquals((String)"100000000000000000", (String)this.vt.getValToString("lb"));
        SmallInterpreterTest.assertEquals((String)"100000000000000001", (String)this.vt.getValToString("lc"));
        SmallInterpreterTest.assertEquals((String)"1.0", (String)this.vt.getValToString("da"));
        SmallInterpreterTest.assertEquals((String)"2.0", (String)this.vt.getValToString("db"));
        SmallInterpreterTest.assertEquals((String)"3.0", (String)this.vt.getValToString("dc"));
        SmallInterpreterTest.assertEquals((String)"3.0", (String)this.vt.getValToString("dd"));
        SmallInterpreterTest.assertEquals((String)"3.0", (String)this.vt.getValToString("de"));
        SmallInterpreterTest.assertEquals((String)"1", (String)this.vt.getValToString("f1"));
        SmallInterpreterTest.assertEquals(Float.TYPE, (Object)this.vt.getType("f1"));
        SmallInterpreterTest.assertEquals((String)"2.0", (String)this.vt.getValToString("f2"));
        SmallInterpreterTest.assertEquals((String)"3.0", (String)this.vt.getValToString("f3"));
        SmallInterpreterTest.assertEquals((String)"4.0", (String)this.vt.getValToString("f4"));
        SmallInterpreterTest.assertEquals((String)"3.0", (String)this.vt.getValToString("f5"));
        SmallInterpreterTest.assertEquals((String)"a", (String)this.vt.getValToString("c1"));
        SmallInterpreterTest.assertEquals((String)"2", (String)this.vt.getValToString("c2"));
        SmallInterpreterTest.assertEquals((String)"ahoge", (String)this.vt.getValToString("ss1"));
        SmallInterpreterTest.assertEquals((String)"true", (String)this.vt.getValToString("b1"));
        SmallInterpreterTest.assertEquals((String)"false", (String)this.vt.getValToString("b2"));
        SmallInterpreterTest.assertEquals((String)"false", (String)this.vt.getValToString("b3"));
        SmallInterpreterTest.assertEquals((String)"10", (String)this.vt.getValToString("i5"));
        SmallInterpreterTest.assertEquals((String)"10", (String)this.vt.getValToString("fff"));
        SmallInterpreterTest.assertEquals((String)"-1000.0", (String)this.vt.getValToString("ddd"));
        SmallInterpreterTest.assertEquals((String)"1000.0", (String)this.vt.getValToString("dddd"));
        SmallInterpreterTest.assertEquals((String)"aho100", (String)this.vt.getValToString("sss"));
        SmallInterpreterTest.assertEquals((String)"0", (String)this.vt.getValToString("iii"));
        SmallInterpreterTest.assertEquals((String)"0", (String)this.vt.getValToString("xx"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii1"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, this.vt.getVal("ii1").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(2), (Object)this.vt.getVal("ii1"));
        SmallInterpreterTest.assertEquals((Object)"a1", (Object)this.vt.getVal("ssb"));
        Class<?> clazz2 = class$6;
        if (clazz2 == null) {
            try {
                clazz2 = class$6 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz2, (Object)this.vt.getType("aho"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getVal("aho"));
    }

    public void test\u3042\u307e\u308a\u3092\u3082\u3068\u3081\u308b\u306e\u306f\u6b63\u3057\u3044\u306e\u304b() {
        SmallInterpreterTest.assertEquals((Object)new Integer(-3), (Object)this.vt.getVal("ii6"));
    }

    public void test\u518d\u5e30\u6f14\u7b97\u306f\u6b63\u3057\u304f\u3044\u304f\u306e\u304b() {
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii2"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, this.vt.getVal("ii2").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(20), (Object)this.vt.getVal("ii2"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii3"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz2, this.vt.getVal("ii3").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(100), (Object)this.vt.getVal("ii3"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii4"));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz3, this.vt.getVal("ii4").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(-70), (Object)this.vt.getVal("ii4"));
        SmallInterpreterTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("ii5"));
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz4, this.vt.getVal("ii5").getClass());
        SmallInterpreterTest.assertEquals((Object)new Integer(-13), (Object)this.vt.getVal("ii5"));
    }

    public void test\u30d0\u30a4\u30c8\u3068\u30b7\u30e7\u30fc\u30c8\u304c\u6b63\u3057\u304f\u3044\u304f\u304b() {
        SmallInterpreterTest.assertEquals(Byte.TYPE, (Object)this.vt.getType("b"));
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz, this.vt.getVal("b").getClass());
        SmallInterpreterTest.assertEquals((Object)new Byte(2), (Object)this.vt.getVal("b"));
        SmallInterpreterTest.assertEquals(Byte.TYPE, (Object)this.vt.getType("bb2"));
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz2, this.vt.getVal("bb2").getClass());
        SmallInterpreterTest.assertEquals((Object)new Byte(-2), (Object)this.vt.getVal("bb2"));
        SmallInterpreterTest.assertEquals(Byte.TYPE, (Object)this.vt.getType("bb3"));
        Class<?> clazz3 = class$8;
        if (clazz3 == null) {
            try {
                clazz3 = class$8 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz3, this.vt.getVal("bb3").getClass());
        SmallInterpreterTest.assertEquals((Object)new Byte(2), (Object)this.vt.getVal("bb3"));
        SmallInterpreterTest.assertEquals(Short.TYPE, (Object)this.vt.getType("short1"));
        Class<?> clazz4 = class$10;
        if (clazz4 == null) {
            try {
                clazz4 = class$10 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz4, this.vt.getVal("short1").getClass());
        SmallInterpreterTest.assertEquals((Object)new Short(1), (Object)this.vt.getVal("short1"));
        SmallInterpreterTest.assertEquals(Short.TYPE, (Object)this.vt.getType("short2"));
        Class<?> clazz5 = class$10;
        if (clazz5 == null) {
            try {
                clazz5 = class$10 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz5, this.vt.getVal("short2").getClass());
        SmallInterpreterTest.assertEquals((Object)new Short(-1), (Object)this.vt.getVal("short2"));
        SmallInterpreterTest.assertEquals(Short.TYPE, (Object)this.vt.getType("short3"));
        Class<?> clazz6 = class$10;
        if (clazz6 == null) {
            try {
                clazz6 = class$10 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterTest.assertEquals(clazz6, this.vt.getVal("short3").getClass());
        SmallInterpreterTest.assertEquals((Object)new Short(-2), (Object)this.vt.getVal("short3"));
    }

    public void testLevel() {
        SmallInterpreterTest.assertEquals((int)2, (int)this.vt.getLevle("i5"));
        SmallInterpreterTest.assertEquals((int)1, (int)this.vt.getLevle("sss"));
        SmallInterpreterTest.assertEquals((int)3, (int)this.vt.getLevle("i6"));
    }

    public void testIsVariable() {
        SmallInterpreterTest.assertEquals((boolean)true, (boolean)this.mi.isVariable("int"));
        SmallInterpreterTest.assertEquals((boolean)true, (boolean)this.mi.isVariable("String"));
        SmallInterpreterTest.assertEquals((boolean)true, (boolean)this.mi.isVariable("TestCase"));
        SmallInterpreterTest.assertEquals((boolean)false, (boolean)this.mi.isVariable("Calc"));
        SmallInterpreterTest.assertEquals((boolean)false, (boolean)this.mi.isVariable("dorararara"));
    }
}

