/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

public class SmallInterpreterForExceptionTest
extends TestCase {
    SmallInterpreter mi;
    VariableTable vt;
    TargetClass target;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        LangMgn.setLang(new Java());
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\ExceptionTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        this.mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
        this.mi.setUpanalyze();
        this.mi.analyze(0);
        this.vt = this.mi.getVariableTable();
        this.target = this.mi.getTargetClass();
    }

    public void testTryCatch\u306e\u4e2d\u304c\u307e\u3068\u3082\u306b\u5b9f\u884c\u3055\u308c\u3066\u3044\u308b\u304b() {
        SmallInterpreterForExceptionTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("i"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterForExceptionTest.assertEquals(clazz, this.vt.getVal("i").getClass());
        SmallInterpreterForExceptionTest.assertEquals((Object)new Integer(1), (Object)this.vt.getVal("i"));
        SmallInterpreterForExceptionTest.assertEquals(Integer.TYPE, (Object)this.vt.getType("j"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SmallInterpreterForExceptionTest.assertEquals(clazz2, this.vt.getVal("j").getClass());
        SmallInterpreterForExceptionTest.assertEquals((Object)new Integer(-1), (Object)this.vt.getVal("j"));
    }

    public void test\u4f8b\u5916() throws Exception {
        this.mi.setUpanalyze();
        this.mi.analyze(0);
        this.mi.setUpanalyze();
        this.mi.analyze(1);
        this.mi.setUpanalyze();
        this.mi.analyze(2);
        this.vt = this.mi.getVariableTable();
        this.target = this.mi.getTargetClass();
        int i = 0;
        while (i < this.target.howManyMethods()) {
            System.out.println(this.target.getMethodName(i));
            ++i;
        }
        SmallInterpreterForExceptionTest.assertTrue((boolean)this.target.hasTargetMethodException(1));
        SmallInterpreterForExceptionTest.assertEquals((int)2, (int)this.target.getTargetMethodException(1).length);
        String[] exceptions = this.target.getTargetMethodException(1);
        System.out.println(exceptions.length);
        System.out.println(this.target.getMethodName(1));
        int i2 = 0;
        while (i2 < exceptions.length) {
            System.out.println(exceptions[i2]);
            ++i2;
        }
    }
}

