/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

public class SmallInterpreter1Test
extends TestCase {
    TargetClass target;

    protected void setUp() throws Exception {
        super.setUp();
        LangMgn.setLang(new Java());
    }

    public void test\u8272\u3005\u306aAssert() throws Exception {
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\AssertsTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        SmallInterpreter mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
        mi.analyze();
        this.target = mi.getTargetClass();
        SmallInterpreter1Test.assertEquals((int)4, (int)this.target.howManyMethods());
        SmallInterpreter1Test.assertEquals((String)"ForAsserts()", (String)this.target.getMethodName(0));
        SmallInterpreter1Test.assertEquals((String)"n()", (String)this.target.getMethodName(1));
        SmallInterpreter1Test.assertEquals((String)"f()", (String)this.target.getMethodName(2));
        SmallInterpreter1Test.assertEquals((String)"t()", (String)this.target.getMethodName(3));
        SmallInterpreter1Test.assertEquals((int)3, (int)this.target.howManyHistories());
        String s = this.target.getHistory(0);
        SmallInterpreter1Test.assertEquals((String)"ForAsserts();n();", (String)s);
        SmallInterpreter1Test.assertEquals((String)"java.lang.Object(@0)", (String)this.target.getValueAtHistory(0));
        s = this.target.getHistory(1);
        SmallInterpreter1Test.assertEquals((String)"ForAsserts();f();", (String)s);
        SmallInterpreter1Test.assertEquals((String)"boolean(false)", (String)this.target.getValueAtHistory(1));
        s = this.target.getHistory(2);
        SmallInterpreter1Test.assertEquals((String)"ForAsserts();f();t();", (String)s);
        SmallInterpreter1Test.assertEquals((String)"boolean(true)", (String)this.target.getValueAtHistory(2));
    }

    public void testArrayUser() throws Exception {
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\ArrayUserTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        SmallInterpreter mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
        mi.analyze();
        this.target = mi.getTargetClass();
        SmallInterpreter1Test.assertEquals((int)6, (int)this.target.howManyMethods());
        SmallInterpreter1Test.assertEquals((String)"ArrayUser()", (String)this.target.getMethodName(0));
        SmallInterpreter1Test.assertEquals((String)"set([I )", (String)this.target.getMethodName(1));
        SmallInterpreter1Test.assertEquals((String)"set(int )", (String)this.target.getMethodName(2));
        SmallInterpreter1Test.assertEquals((String)"length()", (String)this.target.getMethodName(3));
        SmallInterpreter1Test.assertEquals((String)"set([Lorg.kikaineko.source.util.Token; )", (String)this.target.getMethodName(4));
        SmallInterpreter1Test.assertEquals((String)"getToken(org.kikaineko.source.util.Token )", (String)this.target.getMethodName(5));
        SmallInterpreter1Test.assertEquals((boolean)true, (boolean)this.target.isNoChangeMethod("length()"));
    }

    public void testIntUser() throws Exception {
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\IntUserTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        SmallInterpreter mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
        mi.analyze();
        this.target = mi.getTargetClass();
        SmallInterpreter1Test.assertEquals((String)"IntUser()", (String)this.target.getMethodName(0));
        SmallInterpreter1Test.assertEquals((String)"get()", (String)this.target.getMethodName(1));
        SmallInterpreter1Test.assertEquals((String)"int", (String)this.target.getReturnType(1));
        SmallInterpreter1Test.assertEquals((String)"int(10)", (String)this.target.getValueAtHistory(0));
    }

    public void testTestReaderTest0Test() throws Exception {
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\TestReaderTest0Test.java")).getTokenArrayWithoutComment());
        ta.analyze();
        SmallInterpreter mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
        mi.analyze();
        this.target = mi.getTargetClass();
        SmallInterpreter1Test.assertEquals((int)10, (int)this.target.howManyMethods());
        SmallInterpreter1Test.assertEquals((String)"Tasu()", (String)this.target.getMethodName(0));
        SmallInterpreter1Test.assertEquals((String)"add(int int )", (String)this.target.getMethodName(1));
        SmallInterpreter1Test.assertEquals((String)"add(double double )", (String)this.target.getMethodName(2));
        SmallInterpreter1Test.assertEquals((String)"add(float float )", (String)this.target.getMethodName(3));
        SmallInterpreter1Test.assertEquals((String)"int", (String)this.target.getReturnType(3));
        SmallInterpreter1Test.assertEquals((String)"add(long long )", (String)this.target.getMethodName(4));
        SmallInterpreter1Test.assertEquals((String)"long", (String)this.target.getReturnType(4));
        SmallInterpreter1Test.assertEquals((String)"add(java.lang.String java.lang.String )", (String)this.target.getMethodName(5));
        SmallInterpreter1Test.assertEquals((String)"java.lang.String", (String)this.target.getReturnType(5));
        SmallInterpreter1Test.assertEquals((String)"add(char char )", (String)this.target.getMethodName(6));
        SmallInterpreter1Test.assertEquals((String)"char", (String)this.target.getReturnType(6));
        SmallInterpreter1Test.assertEquals((String)"add(int java.lang.String )", (String)this.target.getMethodName(7));
        SmallInterpreter1Test.assertEquals((String)"ok()", (String)this.target.getMethodName(8));
        SmallInterpreter1Test.assertEquals((String)"boolean", (String)this.target.getReturnType(8));
        SmallInterpreter1Test.assertEquals((int)13, (int)this.target.howManyHistories());
        String s = this.target.getHistory(0);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(int int )(int(1) int(1) );", (String)s);
        SmallInterpreter1Test.assertEquals((String)"int(2)", (String)this.target.getValueAtHistory(0));
        s = this.target.getHistory(1);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(int int )(int(2) int(1) );", (String)s);
        SmallInterpreter1Test.assertEquals((String)"int(3)", (String)this.target.getValueAtHistory(1));
        s = this.target.getHistory(2);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(double double )(double(2.0) double(1.0) );", (String)s);
        s = this.target.getHistory(3);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(float float )(float(2.0) float(1.0) );", (String)s);
        SmallInterpreter1Test.assertEquals((String)"int(3)", (String)this.target.getValueAtHistory(3));
        s = this.target.getHistory(4);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(long long )(long(2) long(1) );", (String)s);
        s = this.target.getHistory(5);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(double double )(double(3.0) double(0.0) );", (String)s);
        s = this.target.getHistory(6);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(java.lang.String java.lang.String )(java.lang.String(1) java.lang.String(2) );", (String)s);
        SmallInterpreter1Test.assertEquals((String)"int(3)", (String)this.target.getValueAtHistory(5));
        s = this.target.getHistory(7);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(char char )(char(49) char(50) );", (String)s);
        SmallInterpreter1Test.assertEquals((String)"java.lang.String(3)", (String)this.target.getValueAtHistory(6));
        s = this.target.getHistory(8);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(int java.lang.String )(int(1) java.lang.String(1) );", (String)s);
        s = this.target.getHistory(9);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(double double )(double(1.0) double(2.0) );", (String)s);
        s = this.target.getHistory(10);
        SmallInterpreter1Test.assertEquals((String)"Tasu();add(int int )(int(4) int(-1) );", (String)s);
        s = this.target.getHistory(11);
        SmallInterpreter1Test.assertEquals((String)"Tasu();ok();", (String)s);
        SmallInterpreter1Test.assertEquals((String)"boolean(true)", (String)this.target.getValueAtHistory(11));
        s = this.target.getHistory(12);
        SmallInterpreter1Test.assertEquals((String)"Tasu();ok(boolean )(boolean(false) );", (String)s);
        SmallInterpreter1Test.assertEquals((String)"boolean(false)", (String)this.target.getValueAtHistory(12));
    }
}

