/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.Vector;
import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.MethodSeacher;
import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.analysis.exception.CannotUseMultidimensionalArrayException;
import org.kikaineko.mock.analysis.exception.CannotUseThisTokenException;
import org.kikaineko.mock.analysis.exception.MaybeCannotCompileException;
import org.kikaineko.mock.analysis.exception.TargetCannotBeUsedAtHereException;
import org.kikaineko.mock.analysis.exception.TypeMissMuchException;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.mock.util.FieldCollector;
import org.kikaineko.mock.util.Operator;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;

public class SmallInterpreter
implements Analyst {
    private int index;
    private TestClass testClass;
    private VariableTable vt;
    private TokenArray tokenArray;
    private Stack valueStack;
    private TypeOwner typeStack;
    private int currentLevel = 0;
    private String targetName;
    private TargetClass target;
    protected StringBuffer history;
    protected StringBuffer setUpHistory;
    private VariableTable setUpVt;
    private ClassNameResolver classNameResolver;
    private String lastCallintTargetMethodName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public SmallInterpreter(TestClass tc, TargetClass tar) {
        this.target = tar;
        this.testClass = tc;
        this.targetName = this.target.getInstanceName();
        this.classNameResolver = new ClassNameResolver(tc.packageName(), tc.getImports());
    }

    public void analyze() throws Exception {
        try {
            this.setUpanalyze();
            int i = 0;
            while (i < this.testClass.howManyTestMethods()) {
                this.analyze(i);
                this.tearDownAnalyze();
                ++i;
            }
            this.target.setUsedConcreteClasses(this.typeStack.pushedConcreteClasses());
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Exception("line  " + this.tokenArray.get(this.index).getLineNo() + " has a bad word.");
        }
    }

    protected void setUpanalyze() throws Exception {
        if (this.setUpHistory == null) {
            this.vt = new VariableTable();
            this.valueStack = new Stack();
            this.typeStack = new TypeOwner();
            this.history = new StringBuffer();
            this.tokenArray = this.testClass.getSetUp().getTokenArray();
            this.index = this.tokenArray.indexOfVal("{");
            ++this.index;
            this.block();
            this.setUpHistory = this.history;
            this.setUpVt = this.vt;
        }
    }

    protected void tearDownAnalyze() throws Exception {
        this.valueStack = new Stack();
        this.typeStack = new TypeOwner(this.typeStack.getPushedVec());
        this.vt = new VariableTable();
        this.tokenArray = this.testClass.getTearDown().getTokenArray();
        this.index = this.tokenArray.indexOfVal("{");
        ++this.index;
        this.block();
    }

    protected void analyze(int i) throws Exception {
        this.valueStack = new Stack();
        this.typeStack = new TypeOwner(this.typeStack.getPushedVec());
        this.vt = new VariableTable();
        this.history = new StringBuffer(this.setUpHistory.toString());
        this.tokenArray = this.testClass.getTestMethod(i).getTokenArray();
        this.index = this.tokenArray.indexOfVal("{");
        ++this.index;
        this.block();
    }

    private void block() throws Exception {
        ++this.currentLevel;
        this.blockBody();
        --this.currentLevel;
    }

    private void blockBody() throws Exception {
        while (true) {
            String s;
            if (!(s = this.tokenArray.getVal(this.index++)).equals(this.targetName) && this.isVariable(s)) {
                if (this.tokenArray.getVal(this.index).equals(".")) {
                    this.statement(s);
                    continue;
                }
                Class c = this.classNameResolver.getClazz(s);
                this.variable(c);
                continue;
            }
            if (s.equals("}")) break;
            this.statement(s);
        }
    }

    private int setArray() throws Exception {
        Token t;
        ++this.index;
        int depth = 0;
        while ((t = this.tokenArray.getToken(this.index)).getKind() != 22) {
            if (t.getKind() == 48) {
                ++this.index;
                continue;
            }
            ++depth;
            this.expression();
        }
        ++this.index;
        return depth;
    }

    private void setVariableArray(String name) throws Exception {
        if (this.tokenArray.getVal(this.index).equals("new")) {
            this.expression();
            Object o = this.valueStack.pop();
            this.typeStack.pop();
            this.vt.setValAndLevel(name, o, this.currentLevel);
        } else if (this.tokenArray.getVal(this.index).equals("{")) {
            int leng = this.setArray();
            Object[] os = new Object[leng];
            int i = leng - 1;
            while (i >= 0) {
                os[i] = this.valueStack.pop();
                this.typeStack.pop();
                --i;
            }
            this.vt.setValAndLevel(name, os, this.currentLevel);
        }
    }

    private void variable(Class type) throws Exception {
        Token t;
        if ((t = this.tokenArray.getToken(this.index++)).getKind() != 19) {
            Token t2;
            String name = t.getVal();
            if ((t2 = this.tokenArray.getToken(this.index++)).getKind() != 19) {
                String s = t2.getVal();
                this.vt.addVariable(name, type, this.currentLevel);
                if (s.equals("=")) {
                    this.expression();
                    Object o = this.valueStack.pop();
                    this.typeStack.pop();
                    o = SmallInterpreterSupportor.toByteOrShort(type, o);
                    this.vt.setValAndLevel(name, o, this.currentLevel);
                }
            } else {
                ++this.index;
                String s = this.tokenArray.getVal(this.index);
                if (s.equals("[")) {
                    throw new CannotUseMultidimensionalArrayException(this.tokenArray.getToken(this.index).getLineNo(), "[][]");
                }
                this.vt.addVariable(name, ClassNameResolver.getArrayClass(type), this.currentLevel);
                s = this.tokenArray.getVal(this.index++);
                if (s.equals("=")) {
                    this.setVariableArray(name);
                }
            }
        } else {
            String name;
            ++this.index;
            if ((name = this.tokenArray.getVal(this.index++)).equals("[")) {
                throw new CannotUseMultidimensionalArrayException(this.tokenArray.getToken(this.index).getLineNo(), "[][]");
            }
            this.vt.addVariable(name, ClassNameResolver.getArrayClass(type), this.currentLevel);
            String s = this.tokenArray.getVal(this.index++);
            if (s.equals("=")) {
                this.setVariableArray(name);
            }
        }
        if (this.tokenArray.getVal(this.index).equals(",")) {
            ++this.index;
            this.variable(type);
        }
    }

    private void expression() throws Exception {
        this.term();
        while (true) {
            Token t;
            if ((t = this.tokenArray.getToken(this.index)).getKind() == 8) {
                ++this.index;
                this.term();
                SmallInterpreterSupportor.operation(this.valueStack, this.typeStack, "+");
                continue;
            }
            if (t.getKind() != 9) break;
            ++this.index;
            this.term();
            SmallInterpreterSupportor.operation(this.valueStack, this.typeStack, "-");
        }
    }

    private void term() throws Exception {
        this.factor();
        while (true) {
            Token t;
            if ((t = this.tokenArray.getToken(this.index)).getKind() == 6) {
                ++this.index;
                this.factor();
                SmallInterpreterSupportor.operation(this.valueStack, this.typeStack, "*");
                continue;
            }
            if (t.getKind() == 7) {
                ++this.index;
                this.factor();
                SmallInterpreterSupportor.operation(this.valueStack, this.typeStack, "/");
                continue;
            }
            if (t.getKind() != 34) break;
            ++this.index;
            this.factor();
            SmallInterpreterSupportor.operation(this.valueStack, this.typeStack, "%");
        }
    }

    private void method(String type) throws Exception {
        String name = this.tokenArray.getVal(this.index++);
        Object[] argsO = null;
        Class[] cs = null;
        if (this.tokenArray.getVal(this.index).equals("(")) {
            Object[] oss = this.arg();
            if (oss != null) {
                argsO = (Object[])oss[0];
                cs = (Class[])oss[1];
            }
        } else {
            type = "field";
        }
        Object targetObject = null;
        Object ro = null;
        if (type.equals("method")) {
            targetObject = this.valueStack.pop();
            this.typeStack.pop();
            Class<?> clazz = null;
            clazz = targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass();
            Method m = MethodSeacher.search(clazz, name, cs);
            ro = m.invoke(targetObject, argsO);
            this.typeStack.push(m.getReturnType());
        } else if (type.equals("field")) {
            targetObject = this.valueStack.pop();
            this.typeStack.pop();
            if (name.equals("class")) {
                ro = targetObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.typeStack.push(clazz);
            } else {
                Field f = FieldCollector.getFieldByName(targetObject, name);
                ro = f.get(targetObject);
                this.typeStack.push(ro.getClass());
            }
            --this.index;
        } else {
            Class clazz = this.classNameResolver.getClazz(name);
            Constructor csr = clazz.getConstructor(cs);
            ro = csr.newInstance(argsO);
            this.typeStack.push(ro.getClass());
        }
        this.valueStack.push(ro);
        ++this.index;
        if (this.tokenArray.getVal(this.index).equals(".")) {
            ++this.index;
            this.method("method");
        } else if (this.tokenArray.getVal(this.index).equals("=")) {
            if (!type.equals("field")) {
                throw new MaybeCannotCompileException(this.tokenArray.get(this.index).getLineNo(), "=");
            }
            this.valueStack.pop();
            this.typeStack.pop();
            ++this.index;
            this.expression();
            this.typeStack.pop();
            Field f = FieldCollector.getFieldByName(targetObject, name);
            try {
                f.set(targetObject, this.valueStack.pop());
            }
            catch (Exception e) {
                throw new TypeMissMuchException(this.tokenArray.get(this.index).getLineNo());
            }
        }
    }

    private Object[] arg() throws Exception {
        Vector vec = new Vector();
        Vector cvec = new Vector();
        ++this.index;
        if (this.tokenArray.getVal(this.index).equals(")")) {
            Object[] oss = new Object[2];
            return oss;
        }
        while (true) {
            this.expression();
            vec.add(this.valueStack.pop());
            cvec.add(this.typeStack.pop());
            String s = this.tokenArray.getVal(this.index);
            if (s.equals(")")) break;
            if (!s.equals(",")) continue;
            ++this.index;
        }
        Object[] os = new Object[vec.size()];
        Class[] cs = new Class[cvec.size()];
        int i = 0;
        while (i < os.length) {
            os[i] = vec.get(i);
            cs[i] = (Class)cvec.get(i);
            ++i;
        }
        Object[] oss = new Object[]{os, cs};
        return oss;
    }

    private void constructor() throws Exception {
        this.method("const");
    }

    private void arrayGenerate() throws Exception {
        String type = this.tokenArray.getVal(this.index++);
        ++this.index;
        this.expression();
        Object o = this.valueStack.pop();
        this.typeStack.pop();
        Object os = Array.newInstance(this.classNameResolver.getClazz(type), ((Number)o).intValue());
        this.valueStack.push(os);
        this.typeStack.push(os.getClass());
    }

    private void variableOrClassPush(Token t) {
        this.variableOrClassPush(t.getVal());
    }

    private void variableOrClassPush(String s) {
        if (this.vt.include(s)) {
            this.typeStack.push(this.vt.getType(s));
            this.valueStack.push(this.vt.getVal(s));
        } else {
            Class c = this.classNameResolver.getClazz(s);
            this.typeStack.push(c);
            this.valueStack.push(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void factor() throws Exception {
        Token t;
        if ((t = this.tokenArray.getToken(this.index++)).getKind() == 1) {
            this.index = SmallInterpreterSupportor.numberPush(t, this.tokenArray, this.index, this.valueStack, this.typeStack);
            return;
        }
        if (t.getKind() == 4) {
            if (this.vt.include(t.getVal()) || this.isVariable(t.getVal())) {
                this.variableOrClassPush(t);
                if (this.tokenArray.getVal(this.index).equals(".")) {
                    ++this.index;
                    this.method("method");
                    return;
                }
                if (this.tokenArray.getVal(this.index).equals("[")) {
                    ++this.index;
                    this.expression();
                    int i = ((Number)this.valueStack.pop()).intValue();
                    this.typeStack.pop();
                    this.valueStack.push(Array.get(this.vt.getVal(t.getVal()), i));
                    this.typeStack.push(LangMgn.unitTypeInArray(this.vt.getType(t.getVal())));
                    return;
                }
                if (this.tokenArray.getVal(this.index).equals("++")) {
                    ++this.index;
                    Object o = this.valueStack.peek();
                    Object ro = null;
                    Class<?> clazz = o.getClass();
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz2) {
                        ro = Operator.operate(new Byte(1), o, "+");
                    } else {
                        Class<?> clazz3 = o.getClass();
                        Class<?> clazz4 = class$2;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$2 = Class.forName("java.lang.Short");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ro = clazz3 == clazz4 ? Operator.operate(new Short(1), o, "+") : Operator.operate(new Integer(1), o, "+");
                    }
                    this.vt.setVal(t.getVal(), ro);
                    return;
                }
                if (!this.tokenArray.getVal(this.index).equals("--")) return;
                ++this.index;
                Object o = this.valueStack.peek();
                Object ro = null;
                Class<?> clazz = o.getClass();
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz5) {
                    ro = Operator.operate(new Byte(1), o, "-");
                } else {
                    Class<?> clazz6 = o.getClass();
                    Class<?> clazz7 = class$2;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$2 = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ro = clazz6 == clazz7 ? Operator.operate(new Short(1), o, "-") : Operator.operate(new Integer(1), o, "-");
                }
                this.vt.setVal(t.getVal(), ro);
                return;
            }
            if (t.getVal().equals("true")) {
                this.valueStack.push(new Boolean(true));
                this.typeStack.push(Boolean.TYPE);
                return;
            }
            if (t.getVal().equals("false")) {
                this.valueStack.push(new Boolean(false));
                this.typeStack.push(Boolean.TYPE);
                return;
            }
            if (t.getVal().equals("new")) {
                if (this.tokenArray.getVal(this.index + 1).equals("[")) {
                    this.arrayGenerate();
                    return;
                } else {
                    this.constructor();
                }
                return;
            }
            if (t.getVal().equals("null")) {
                this.valueStack.push(null);
                this.typeStack.push((Object)null);
                return;
            }
            if (t.getVal().equals(this.targetName)) {
                throw new TargetCannotBeUsedAtHereException(t.getLineNo(), t.getVal());
            }
            if (!LangMgn.isPremit(t.getVal())) return;
            System.out.println(39);
            if (!this.tokenArray.getVal(this.index + 1).equals("class")) throw new MaybeCannotCompileException(this.tokenArray.getToken(this.index + 1).getLineNo(), this.tokenArray.getVal(this.index + 1));
            ++this.index;
            ++this.index;
            this.valueStack.push(LangMgn.getPremitClass(t.getVal()));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.typeStack.push(clazz);
            return;
        }
        if (t.getKind() == 9) {
            this.factor();
            Object o = this.valueStack.pop();
            this.negatePush(o);
            return;
        }
        if (t.getKind() == 13) {
            Class c = this.classNameResolver.getClazz(this.tokenArray.getVal(this.index));
            if (c != null && this.tokenArray.getVal(this.index + 1).equals(")")) {
                this.cast(c);
                return;
            } else {
                this.expression();
                ++this.index;
            }
            return;
        }
        if (t.getKind() == 16) {
            Class<?> clazz;
            if (this.tokenArray.getKind(this.index) == 16) {
                this.valueStack.push("");
            } else {
                this.valueStack.push(this.tokenArray.getVal(this.index++));
            }
            if ((clazz = class$4) == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.typeStack.push(clazz);
            ++this.index;
            return;
        }
        if (t.getKind() == 17) {
            this.valueStack.push(new Character(this.tokenArray.getVal(this.index++).charAt(0)));
            this.typeStack.push(Character.TYPE);
            ++this.index;
            return;
        } else if (t.getKind() == 24) {
            this.factor();
            Object o = this.valueStack.pop();
            this.negatePush(o);
            return;
        } else if (t.getKind() == 10) {
            Token tt = this.tokenArray.getToken(this.index++);
            this.variableOrClassPush(tt);
            Object o = this.valueStack.pop();
            Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");
            this.vt.setVal(tt.getVal(), ro);
            this.valueStack.push(ro);
            return;
        } else {
            if (t.getKind() != 11) throw new MaybeCannotCompileException(t.getLineNo(), t.getVal());
            Token tt = this.tokenArray.getToken(this.index++);
            this.variableOrClassPush(tt);
            Object o = this.valueStack.pop();
            Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");
            this.vt.setVal(tt.getVal(), ro);
            this.valueStack.push(ro);
        }
    }

    private void cast(Class c) throws Exception {
        ++this.index;
        ++this.index;
        this.expression();
        this.typeStack.pop();
        this.typeStack.push(c);
    }

    private void negatePush(Object o) {
        SmallInterpreterSupportor.negatePush(this.valueStack, o);
    }

    private void callingVariable(String s) throws Exception {
        Token t;
        if ((t = this.tokenArray.getToken(this.index++)).getKind() == 5) {
            this.expression();
            this.vt.setVal(s, this.valueStack.pop());
        } else if (t.getKind() == 36) {
            this.expression();
            Object o = this.valueStack.pop();
            this.vt.setVal(s, Operator.operate(this.vt.getVal(s), o, "+"));
        } else if (t.getKind() == 38) {
            this.expression();
            Object o = this.valueStack.pop();
            this.vt.setVal(s, Operator.operate(this.vt.getVal(s), o, "*"));
        } else if (t.getKind() == 37) {
            this.expression();
            Object o = this.valueStack.pop();
            this.vt.setVal(s, Operator.operate(o, this.vt.getVal(s), "-"));
        } else if (t.getKind() == 39) {
            this.expression();
            Object o = this.valueStack.pop();
            this.vt.setVal(s, Operator.operate(o, this.vt.getVal(s), "/"));
        } else if (t.getKind() == 15) {
            this.variableOrClassPush(s);
            this.method("method");
        } else if (t.getKind() == 19) {
            this.expression();
            int i = ((Number)this.valueStack.pop()).intValue();
            this.typeStack.pop();
            ++this.index;
            ++this.index;
            this.expression();
            Object o = this.valueStack.pop();
            this.typeStack.pop();
            Array.set(this.vt.getVal(s), i, o);
        } else if (t.getKind() == 10) {
            Object o = this.vt.getVal(s);
            this.valueStack.push(o);
            this.typeStack.push(this.vt.getType(s));
            Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");
            this.vt.setVal(s, ro);
        } else if (t.getKind() == 11) {
            Object o = this.vt.getVal(s);
            this.valueStack.push(o);
            this.typeStack.push(this.vt.getType(s));
            Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");
            this.vt.setVal(s, ro);
        }
    }

    private void statement(String s) throws Exception {
        if (this.vt.include(s) || this.isVariable(s)) {
            this.callingVariable(s);
        } else if (s.equals("{")) {
            this.block();
        } else if (s.equals("++")) {
            Token t = this.tokenArray.getToken(this.index++);
            this.variableOrClassPush(t);
            Object o = this.valueStack.pop();
            Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");
            this.vt.setVal(t.getVal(), ro);
            this.valueStack.push(ro);
        } else if (s.equals("--")) {
            Token t = this.tokenArray.getToken(this.index++);
            this.variableOrClassPush(t);
            Object o = this.valueStack.pop();
            Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");
            this.vt.setVal(t.getVal(), ro);
            this.valueStack.push(ro);
        } else if (s.equals("assertEquals")) {
            this.assertEq();
        } else if (s.equals("assertTrue")) {
            this.assertTr();
        } else if (s.equals("assertFalse")) {
            this.assertFl();
        } else if (s.equals("assertNull")) {
            this.assertNl();
        } else if (s.equals(this.targetName)) {
            this.targetInvoke();
        } else if (s.equals("try")) {
            this.tryCatch();
            if (this.tokenArray.getVal(this.index).equals("finally")) {
                ++this.index;
                this.block();
                --this.index;
            }
        } else if (s.equals("catch")) {
            this.ignoreCatch();
        } else if (s.equals("finally")) {
            ++this.index;
            this.block();
        } else if (s.equals("super")) {
            this.index = this.tokenArray.indexOfVal(";", this.index);
            ++this.index;
        } else {
            if (LangMgn.cannotUseThisReservedWordNow(s)) {
                throw new CannotUseThisTokenException(this.tokenArray.getToken(this.index).getLineNo(), s);
            }
            if (this.tokenArray.getKind(this.index - 1) == 4) {
                Token t = this.tokenArray.getToken(this.index - 1);
                throw new MaybeCannotCompileException(t.getLineNo(), t.getVal());
            }
        }
    }

    private void ignoreCatch() {
        this.index += 4;
        int catchLevel = 0;
        do {
            String s;
            if ((s = this.tokenArray.getVal(this.index++)).equals("{")) {
                ++catchLevel;
                continue;
            }
            if (!s.equals("}")) continue;
            --catchLevel;
        } while (catchLevel != 0);
    }

    private void tryCatch() throws Exception {
        ++this.index;
        ++this.currentLevel;
        this.tryCatchBlockBody();
        --this.currentLevel;
    }

    private void tryCatchBlockBody() throws Exception {
        while (true) {
            String s;
            if ((s = this.tokenArray.getVal(this.index++)).equals("fail")) {
                this.failCatch();
                continue;
            }
            if (!s.equals(this.targetName) && this.isVariable(s)) {
                Class c = this.classNameResolver.getClazz(s);
                this.variable(c);
                continue;
            }
            if (s.equals("}")) break;
            this.statement(s);
        }
    }

    private void failCatch() {
        this.index = this.tokenArray.indexOfVal("catch", this.index);
        this.index += 2;
        String s = this.tokenArray.getVal(this.index++);
        Class exceptionClazz = this.classNameResolver.getClazz(s);
        String exceptionName = exceptionClazz.getName();
        this.target.addHistory(this.history.toString(), "throw new " + exceptionName);
        this.target.addException(this.lastCallintTargetMethodName, exceptionName);
        this.index += 3;
    }

    private void assertEq() throws Exception {
        this.expression();
        this.assertEqActual();
    }

    private void assertTr() throws Exception {
        this.valueStack.push(new Boolean(true));
        this.typeStack.push(Boolean.TYPE);
        ++this.index;
        this.assertEqActual();
    }

    private void assertFl() throws Exception {
        this.valueStack.push(new Boolean(false));
        this.typeStack.push(Boolean.TYPE);
        ++this.index;
        this.assertEqActual();
    }

    private void assertNl() throws Exception {
        this.valueStack.push(null);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.typeStack.push(clazz);
        ++this.index;
        this.assertEqActual();
    }

    private void assertEqActual() throws Exception {
        Object o = this.valueStack.pop();
        Class c = (Class)this.typeStack.pop();
        if (this.tokenArray.getVal(this.index).equals(this.targetName)) {
            ++this.index;
            this.doTargetInvoking(o, c, false);
        } else {
            this.expression();
            boolean noChangeStateFlag = "noChangeState".equals((String)o);
            o = this.valueStack.pop();
            c = (Class)this.typeStack.pop();
            ++this.index;
            if (this.tokenArray.getVal(this.index++).equals(this.targetName)) {
                this.doTargetInvoking(o, c, noChangeStateFlag);
            }
        }
    }

    private void doTargetInvoking(Object expectedValue, Class expectedClass, boolean noChangeStateFlag) throws Exception {
        String tempHistory = this.history.toString();
        String name = this.targetInvoke();
        this.target.addHistory(this.history.toString(), ToStringer.get(expectedValue));
        this.target.overWriteMethodReType(name, LangMgn.getClassName(expectedClass));
        if (noChangeStateFlag) {
            this.target.addNoChange(name);
            this.history = new StringBuffer(tempHistory);
        }
    }

    private String targetInvoke() throws Exception {
        Token t = this.tokenArray.getToken(this.index++);
        String name = null;
        if (t.getKind() == 15) {
            name = this.targetMethod();
        } else if (t.getKind() == 5) {
            if (this.tokenArray.getVal(this.index).equals("new")) {
                ++this.index;
                name = this.targetMethod();
                this.target.setMethodReType(name, "");
                String className = name.substring(0, name.indexOf(40));
                if (!this.target.getClassName().equals(className)) {
                    this.target.setClassName(className);
                    Class c = this.classNameResolver.getClazz(this.target.getSuperName());
                    this.target.setSuperClass(c);
                }
            } else {
                Object o = null;
                try {
                    this.expression();
                    o = this.valueStack.pop();
                    this.typeStack.pop();
                }
                catch (Throwable e) {
                    System.out.println(33);
                    e.printStackTrace();
                }
                if (o == null) {
                    name = String.valueOf(this.target.getSuperName()) + "Impl()";
                    this.target.addMethod(name, "");
                    String className = name.substring(0, name.indexOf(40));
                    this.target.setClassName(className);
                    Class c = this.classNameResolver.getClazz(this.target.getSuperName());
                    this.target.setSuperClass(c);
                } else {
                    name = String.valueOf(o.getClass().getName()) + "()";
                    name = name.substring(name.lastIndexOf(".") + 1);
                    this.target.addMethod(name, "");
                    String className = name.substring(0, name.indexOf(40));
                    this.target.setClassName(className);
                    Class c = this.classNameResolver.getClazz(this.target.getSuperName());
                    this.target.setSuperClass(c);
                }
            }
        }
        return name;
    }

    private String targetMethod() throws Exception {
        String name = this.tokenArray.getVal(this.index++);
        Object[] o2 = this.arg();
        Object[] argsVaules = (Object[])o2[0];
        Class[] argsClasses = (Class[])o2[1];
        String methodSign = SmallInterpreterSupportor.getMethodSignature(argsClasses, name);
        this.target.addMethod(methodSign, "void");
        this.lastCallintTargetMethodName = methodSign;
        SmallInterpreterSupportor.appendHistory(this.history, methodSign, argsVaules);
        return methodSign;
    }

    protected boolean isVariable(String s) {
        return SmallInterpreterSupportor.isVariable(this.classNameResolver, s);
    }

    public TargetClass getTargetClass() {
        return this.target;
    }

    public TestClass getTestClass() {
        return this.testClass;
    }

    protected VariableTable getVariableTable() {
        return this.vt;
    }
}

