/*
 * Decompiled with CFR 0.152.
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import java.util.Vector;
import junit.framework.TestCase;
import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.sourcescan.CodeReader;

public class ClassNameResolverTest
extends TestCase {
    ClassNameResolver cnr;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void setUp() throws Exception {
        super.setUp();
        TestAnalyst ta = new TestAnalyst(new CodeReader(new File("src\\fortest\\ArrayUserTest.java")).getTokenArrayWithoutComment());
        ta.analyze();
        this.cnr = new ClassNameResolver(ta.getTestClass().packageName(), ta.getTestClass().getImports());
    }

    public void test\u30af\u30e9\u30b9\u306e\u30d5\u30eb\u30cd\u30fc\u30e0\u5019\u88dc\u304c\u53d6\u5f97\u3067\u304d\u3066\u3044\u308b\u304b() {
        Vector names = this.cnr.getListFullClassNames("Token");
        ClassNameResolverTest.assertEquals((int)1, (int)names.size());
        ClassNameResolverTest.assertEquals((String)"org.kikaineko.source.util.Token", (String)((String)names.get(0)));
        names = this.cnr.getListFullClassNames("Hoge");
        ClassNameResolverTest.assertEquals((int)2, (int)names.size());
        ClassNameResolverTest.assertEquals((String)"fortest.Hoge", (String)((String)names.get(0)));
        ClassNameResolverTest.assertEquals((String)"java.lang.Hoge", (String)((String)names.get(1)));
    }

    public void testGetClazz() {
        ClassNameResolverTest.assertEquals(Integer.TYPE, (Object)this.cnr.getClazz("int"));
        ClassNameResolverTest.assertEquals(Integer.TYPE, (Object)this.cnr.getClazz("int"));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassNameResolverTest.assertEquals(clazz, (Object)this.cnr.getClazz("String"));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("junit.framework.TestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassNameResolverTest.assertEquals(clazz2, (Object)this.cnr.getClazz("TestCase"));
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.kikaineko.source.util.Token");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassNameResolverTest.assertEquals(clazz3, (Object)this.cnr.getClazz("Token"));
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("fortest.ArrayUser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassNameResolverTest.assertEquals(clazz4, (Object)this.cnr.getClazz("ArrayUser"));
    }
}

