struct msg_map : ketchup::entry_set<CHelloView>
{
	struct cmd_ui_map_sub;	// forward declaration also works fine.
		
	struct cmd_ui_map : sequence<
		cmd_ui_handler<ID_BLACK, &_::OnUpdateBlack>,
		cmd_ui_handler<ID_RED, &_::OnUpdateRed>,
		cmd_ui_handler<ID_GREEN, &_::OnUpdateGreen>,
		cmd_ui_map_sub				// chain
	> { };

	struct cmd_ui_map_sub : sequence<
		cmd_ui_handler<ID_BLUE, &_::OnUpdateBlue>,
		sequence<							// chain
			cmd_ui_handler<ID_WHITE, &_::OnUpdateWhite>,
			cmd_ui_handler<ID_CUSTOM, &_::OnUpdateCustom>
		>
	> { };

	typedef sequence<
		cmd_ui_map,						// chain
		msg_wm_paint<&_::OnPaint>,
		command_range_handler<ID_BLACK, ID_WHITE, &_::OnColor>,
		command_id_handler<ID_CUSTOM, &_::OnCustomColor>
	> type;
};
