#pragma once
///////////////////////////////////////////////////////////////////////////////
// ketchup/verify.hpp
// 
// Note:
//  verify can change the semantics of programs, so
//  it should be not a macro but a function.
//  The optimization can completely remove the following code.
//  A program which is made slower by verify, requires the optimization!
//
#include <cassert>
#include <boost/mpl/eval_if.hpp>
#include "utility/is_debug.hpp"

namespace ketchup {

	namespace detail {

	struct debug_verify
	{
		static void eval(int expr)
		{
			(expr);
			assert(expr);
		}

		typedef debug_verify type;
	};

	struct release_verify
	{
		static void eval(int) { }

		typedef release_verify type;
	};

	} // namespace detail

inline void verify(int expr)
{
	typedef boost::mpl::eval_if<utility::is_debug,
		detail::debug_verify,
		detail::release_verify
	>::type func;
	
	func::eval(expr);
}

} // namespace ketchup

