#pragma once
///////////////////////////////////////////////////////////////////////////////
// ketchup/get_trace.hpp
// 
// Note:
//  get_trace depends on optimization..., but this is the modern programming.
//
#include <boost/mpl/and.hpp>
#include <boost/mpl/apply.hpp>
#include <boost/mpl/bool.hpp>
#include <boost/mpl/if.hpp>
#include <boost/mpl/placeholders.hpp>
#include <typeinfo>
#include "utility/is_debug.hpp"

namespace ketchup {

	namespace detail {

	// Note: if inline missed, the compiler doesn't remove s_count.
	inline int& trace_indent_count()
	{
		static int s_count = 0;
		return s_count;
	}

	template< class T, int SpaceCount >
	struct trace_impl_on
	{
		explicit trace_impl_on(LPCTSTR str)
		{
			int spaces = SpaceCount*trace_indent_count();
			for (int i = 0; i < spaces; ++i) {
				ATLTRACE(_T(" "));
			}
			// Note: For the compiler, it seems better to define a temporary tid.
			const std::type_info& tid = typeid(T);
			ATLTRACE(tid.name());
			ATLTRACE(_T("::"));
			ATLTRACE(str);
			ATLTRACE(_T("\n"));
			++trace_indent_count();
		}

		~trace_impl_on()
		{
			--trace_indent_count();
		}

		typedef trace_impl_on type;
	};

	template< class, int >
	struct trace_impl_off
	{
		explicit trace_impl_off(LPCTSTR) { }
		
		typedef trace_impl_off type;
	};

	} // namespace detail

template< class T, class On = boost::mpl::true_, int SpaceCount = 1 >
struct get_trace
{
	// Note: eval_if can make C4510 and C4610 warnings
	typedef typename boost::mpl::if_<
		boost::mpl::and_< utility::is_debug, On >,
		detail::trace_impl_on<T, SpaceCount>,
		detail::trace_impl_off<T, SpaceCount>
	>::type type;
};

} // namespace ketchup
