#pragma once

#include <cassert>
#include <boost/mpl/eval_if.hpp>
#include <boost/mpl/identity.hpp>

#include "../utility/ignore_unused_variables_warning.hpp"
#include "../utility/is_debug.hpp"


namespace ketchup {

struct helper_entry_set
{

	struct assert_entry
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			assert(false);
			return false;
		}
	};

	struct empty_entry
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			return false;
		}
	};

	template< class Entry >
	struct debug_entry
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			typedef boost::mpl::eval_if<utility::is_debug,
				boost::mpl::identity<Entry>,
				boost::mpl::identity<empty_entry>
			>::type entry_t;
			
			return entry_t::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);
		}
	};

	template< class Entry >
	struct identity_entry
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			return Entry::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);
		}
	};

}; // helper_entry_set

} // namespace ketchup
