
#ifndef BOOST_PP_IS_ITERATING

	#ifndef KETCHUP_SEQUENCE_ENTRY_SET_INCLUDED
		#define KETCHUP_SEQUENCE_ENTRY_SET_INCLUDED

		#include <boost/preprocessor/arithmetic/sub.hpp>
		#include <boost/preprocessor/cat.hpp>
		#include <boost/preprocessor/comparison/equal.hpp>
		#include <boost/preprocessor/facilities/identity.hpp>
		#include <boost/preprocessor/iteration/iterate.hpp>
		#include <boost/preprocessor/iteration/local.hpp>
		#include <boost/preprocessor/repetition/enum_params.hpp>
		#include <boost/preprocessor/repetition/enum_params_with_a_default.hpp>
		#include <boost/preprocessor/repetition/repeat.hpp>
		#include <boost/preprocessor/stringize.hpp>

		#ifndef KETCHUP_LIMIT_SEQUENCE_SIZE
			#define KETCHUP_LIMIT_SEQUENCE_SIZE 30
		#endif
		
		// local macro
		#define KETCHUP_sequence_statement(z, i, unused) \
		if (E##i::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID)) \
		{ \
			return true; \
		} \
		/**/

		// header
		BOOST_PP_IDENTITY(#pragma once)()
		BOOST_PP_IDENTITY(#include "boost/mpl/void.hpp")()
		
		namespace ketchup
		{
			struct sequence_entry_set
			{


// primary
template<
	BOOST_PP_ENUM_PARAMS_WITH_A_DEFAULT(KETCHUP_LIMIT_SEQUENCE_SIZE, class E, boost::mpl::void_)
>
struct sequence
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_sequence_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, KETCHUP_LIMIT_SEQUENCE_SIZE-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};

// empty
template<
>
struct sequence<
>
{
	template< class Derived >
	static bool process(Derived&, HWND, UINT, WPARAM, LPARAM, LRESULT&, DWORD)
	{
		return false;
	}
};


		#define BOOST_PP_ITERATION_LIMITS(1, KETCHUP_LIMIT_SEQUENCE_SIZE-1)
		#define BOOST_PP_FILENAME_1 "sequence_entry_set.hpp"
		#include BOOST_PP_ITERATE()

		// clean up
		
			}; // struct sequence_entry_set
		} // namespace ketchup
		
		#undef KETCHUP_sequence_statement

	#endif // KETCHUP_SEQUENCE_ENTRY_SET_INCLUDED

#else // BOOST_PP_IS_ITERATING

	#define n BOOST_PP_ITERATION()


template<
	BOOST_PP_ENUM_PARAMS(n, class E)
>
struct sequence<
	BOOST_PP_ENUM_PARAMS(n, E)
>
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_sequence_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, n-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};


	#undef n

#endif // BOOST_PP_IS_ITERATING
