
#ifndef BOOST_PP_IS_ITERATING

	#ifndef KETCHUP_ALTERNATIVE_ENTRY_SET_INCLUDED
		#define KETCHUP_ALTERNATIVE_ENTRY_SET_INCLUDED

		#include <boost/preprocessor/arithmetic/sub.hpp>
		#include <boost/preprocessor/cat.hpp>
		#include <boost/preprocessor/comparison/equal.hpp>
		#include <boost/preprocessor/facilities/identity.hpp>
		#include <boost/preprocessor/iteration/iterate.hpp>
		#include <boost/preprocessor/iteration/local.hpp>
		#include <boost/preprocessor/repetition/enum_params.hpp>
		#include <boost/preprocessor/repetition/enum_params_with_a_default.hpp>
		#include <boost/preprocessor/repetition/repeat.hpp>
		#include <boost/preprocessor/stringize.hpp>

		#ifndef KETCHUP_LIMIT_ALTERNATIVE_SIZE
			#define KETCHUP_LIMIT_ALTERNATIVE_SIZE 30
		#endif
		
		// local macro
		#define KETCHUP_alternative_statement(z, i, unused) \
		if (E##i::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID)) \
		{ \
			return true; \
		} \
		/**/

		// header
		BOOST_PP_IDENTITY(#pragma once)()
		BOOST_PP_IDENTITY(#include "boost/mpl/void.hpp")()
		
		namespace ketchup
		{
			struct alternative_entry_set
			{

// primary
template<
	DWORD msgMapID,
	BOOST_PP_ENUM_PARAMS_WITH_A_DEFAULT(KETCHUP_LIMIT_ALTERNATIVE_SIZE, class E, boost::mpl::void_)
>
struct alternative
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		if (msgMapID != dwMsgMapID) { return false; }
		
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_alternative_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, KETCHUP_LIMIT_ALTERNATIVE_SIZE-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};

// empty
template<
	DWORD msgMapID
>
struct alternative<
	msgMapID
>
{
	template< class Derived >
	static bool process(Derived&, HWND, UINT, WPARAM, LPARAM, LRESULT&, DWORD)
	{
		return false;
	}
};


		#define BOOST_PP_ITERATION_LIMITS(1, KETCHUP_LIMIT_ALTERNATIVE_SIZE-1)
		#define BOOST_PP_FILENAME_1 "alternative_entry_set.hpp"
		#include BOOST_PP_ITERATE()

		// clean up
		
			}; // struct alternative_entry_set
		} // namespace ketchup
		
		#undef KETCHUP_alternative_statement

	#endif // KETCHUP_ALTERNATIVE_ENTRY_SET_INCLUDED

#else // BOOST_PP_IS_ITERATING

	#define n BOOST_PP_ITERATION()


template<
	DWORD msgMapID,
	BOOST_PP_ENUM_PARAMS(n, class E)
>
struct alternative<
	msgMapID,
	BOOST_PP_ENUM_PARAMS(n, E)
>
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		if (msgMapID != dwMsgMapID) { return false; }
		
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_alternative_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, n-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};


	#undef n

#endif // BOOST_PP_IS_ITERATING
