///////////////////////////////////////////////////////////////////////////////
// GENERATED BY msg_wm_converter
//

///////////////////////////////////////////////////////////////////////////////
// alt_msg_map
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// message_handler
//
template<
	UINT msg,LRESULT (Derived::*func)(UINT,WPARAM,LPARAM,BOOL&)
>
struct message_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == msg)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(uMsg, wParam, lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// message_range_handler
//
template<
	UINT msgFirst,UINT msgLast,LRESULT (Derived::*func)(UINT,WPARAM,LPARAM,BOOL&)
>
struct message_range_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg >= msgFirst && uMsg <= msgLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(uMsg, wParam, lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// command_handler
//
template<
	UINT id,UINT code,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct command_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_COMMAND && id == LOWORD(wParam) && code == HIWORD(wParam))
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// command_id_handler
//
template<
	UINT id,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct command_id_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_COMMAND && id == LOWORD(wParam))
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// command_code_handler
//
template<
	UINT code,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct command_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_COMMAND && code == HIWORD(wParam))
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// command_range_handler
//
template<
	UINT idFirst,UINT idLast,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct command_range_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_COMMAND && LOWORD(wParam) >= idFirst  && LOWORD(wParam) <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// command_range_code_handler
//
template<
	UINT idFirst,UINT idLast,UINT code,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct command_range_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_COMMAND && code == HIWORD(wParam) && LOWORD(wParam) >= idFirst  && LOWORD(wParam) <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// notify_handler
//
template<
	UINT id,UINT cd,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct notify_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_NOTIFY && id == ((LPNMHDR)lParam)->idFrom && cd == ((LPNMHDR)lParam)->code)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// notify_id_handler
//
template<
	UINT id,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct notify_id_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_NOTIFY && id == ((LPNMHDR)lParam)->idFrom)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// notify_code_handler
//
template<
	UINT cd,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct notify_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_NOTIFY && cd == ((LPNMHDR)lParam)->code)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// notify_range_handler
//
template<
	UINT idFirst,UINT idLast,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct notify_range_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_NOTIFY && ((LPNMHDR)lParam)->idFrom >= idFirst && ((LPNMHDR)lParam)->idFrom <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// notify_range_code_handler
//
template<
	UINT idFirst,UINT idLast,UINT cd,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct notify_range_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == WM_NOTIFY && cd == ((LPNMHDR)lParam)->code && ((LPNMHDR)lParam)->idFrom >= idFirst && ((LPNMHDR)lParam)->idFrom <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// chain_msg_map
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// chain_msg_map_member
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// chain_msg_map_alt
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// chain_msg_map_alt_member
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// chain_msg_map_dynamic
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// end_msg_map
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);


// Empty message map macro

///////////////////////////////////////////////////////////////////////////////
// declare_empty_msg_map
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


// Message forwarding and reflection macros

///////////////////////////////////////////////////////////////////////////////
// forward_notifications
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// reflect_notifications
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// default_reflection_handler
//
// MANUAL_FIX_REQUIRED_for_NO_FUNC_CALL


///////////////////////////////////////////////////////////////////////////////
// reflected_command_handler
//
template<
	UINT id,UINT code,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct reflected_command_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_COMMAND && id == LOWORD(wParam) && code == HIWORD(wParam))
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_command_id_handler
//
template<
	UINT id,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct reflected_command_id_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_COMMAND && id == LOWORD(wParam))
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_command_code_handler
//
template<
	UINT code,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct reflected_command_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_COMMAND && code == HIWORD(wParam))
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_command_range_handler
//
template<
	UINT idFirst,UINT idLast,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct reflected_command_range_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_COMMAND && LOWORD(wParam) >= idFirst  && LOWORD(wParam) <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_command_range_code_handler
//
template<
	UINT idFirst,UINT idLast,UINT code,LRESULT (Derived::*func)(WORD,WORD,HWND,BOOL&)
>
struct reflected_command_range_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_COMMAND && code == HIWORD(wParam) && LOWORD(wParam) >= idFirst  && LOWORD(wParam) <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)(HIWORD(wParam), LOWORD(wParam), (HWND)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_notify_handler
//
template<
	UINT id,UINT cd,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct reflected_notify_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_NOTIFY && id == ((LPNMHDR)lParam)->idFrom && cd == ((LPNMHDR)lParam)->code)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_notify_id_handler
//
template<
	UINT id,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct reflected_notify_id_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_NOTIFY && id == ((LPNMHDR)lParam)->idFrom)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_notify_code_handler
//
template<
	UINT cd,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct reflected_notify_code_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_NOTIFY && cd == ((LPNMHDR)lParam)->code)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
///////////////////////////////////////////////////////////////////////////////
// reflected_notify_range_handler
//
template<
	UINT idFirst,UINT idLast,LRESULT (Derived::*func)(int,LPNMHDR,BOOL&)
>
struct reflected_notify_range_handler
{
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		(derived); (hWnd); (uMsg); (wParam); (lParam); (lResult); (dwMsgMapID);

		if(uMsg == OCM_NOTIFY && ((LPNMHDR)lParam)->idFrom >= idFirst && ((LPNMHDR)lParam)->idFrom <= idLast)
		{
			BOOL bHandled = TRUE;
			lResult = (derived.*func)((int)wParam, (LPNMHDR)lParam, bHandled);
			if(bHandled)
				return true;
		}
	
		return false;
	}
};
