#pragma once

#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup {

struct aux_standard_entry_set
{

	struct chain_client_commands
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == WM_COMMAND)
			{
				HWND hWnd = derived.m_hWndClient;
				if (hWnd != NULL)
					::SendMessage(hWnd, uMsg, wParam, lParam);
				return false;
			}

			return false;
		}
	};

	struct chain_mdi_child_commands
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == WM_COMMAND)
			{
				HWND hWndChild = derived.MDIGetActive();
				if (hWndChild != NULL)
					::SendMessage(hWndChild, uMsg, wParam, lParam);
				return false;
			}
			return false;
		}
	};

	template< class ChainClass, DWORD msgMapID >
	struct chain_msg_map_alt
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			return derived.ChainClass::ProcessWindowMessage(hWnd, uMsg, wParam, lParam, lResult, msgMapID) == TRUE;
		}
	};

	template< class ChainClass >
	struct chain_msg_map : chain_msg_map_alt<ChainClass, 0>
	{
	};

	template< DWORD dynaChainID >
	struct chain_msg_map_dynamic
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			return CDynamicChain::CallChain(dynaChainID, hWnd, uMsg, wParam, lParam, lResult) == TRUE;
		}
	};

	template< class FunctorClass, DWORD msgMapID >
	struct chain_msg_map_alt_member
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			return FunctorClass()(derived).ProcessWindowMessage(hWnd, uMsg, wParam, lParam, lResult, msgMapID) == TRUE;
		}
	};

	template< class FunctorClass >
	struct chain_msg_map_member : chain_msg_map_alt_member<FunctorClass, 0>
	{
	};

	struct default_reflection_handler
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			return Derived::DefaultReflectionHandler(hWnd, uMsg, wParam, lParam, lResult) == TRUE;
		}
	};

	struct forward_notifications
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			bHandled = TRUE;
			lResult = derived.ForwardNotifications(uMsg, wParam, lParam, bHandled);
			if(bHandled)
				return true;
		}
	};

}; // standard_entry_set

} // namespace ketchup
