#pragma once

#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

struct default_reflection_handler
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		return Derived::DefaultReflectionHandler(hWnd, uMsg, wParam, lParam, lResult) == TRUE;
	}
};

} // namespace ketchup
