#pragma once

#include <boost/mpl/eval_if.hpp>
#include <boost/mpl/identity.hpp>

#include "../utility/ignore_unused_variables_warning.hpp"
#include "../utility/is_debug.hpp"
#include "empty_entry.hpp"

namespace ketchup
{

template< class Entry >
struct debug_entry
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		typedef boost::mpl::eval_if<utility::is_debug,
			boost::mpl::identity<Entry>,
			boost::mpl::identity<empty_entry>
		>::type entry_t;
		
		return entry_t::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);
	}
};

} // namespace ketchup
