#pragma once

#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

	template< class FunctorClass, DWORD msgMapID >
	struct chain_msg_map_alt_member
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			return FunctorClass()(derived).ProcessWindowMessage(hWnd, uMsg, wParam, lParam, lResult, msgMapID) == TRUE;
		}
	};
	
	template< class FunctorClass >
	struct chain_msg_map_member : chain_msg_map_alt_member<FunctorClass, 0>
	{
	};

}