#pragma once

#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

template< class ChainClass, DWORD msgMapID >
struct chain_msg_map_alt
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		return derived.ChainClass::ProcessWindowMessage(hWnd, uMsg, wParam, lParam, lResult, msgMapID) == TRUE;
	}
};

template< class ChainClass >
struct chain_msg_map : chain_msg_map_alt<ChainClass, 0>
{
};

} // namespace ketchup
