#pragma once

#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

struct chain_mdi_child_commands
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		if (uMsg == WM_COMMAND)
		{
			HWND hWndChild = derived.MDIGetActive();
			if (hWndChild != NULL)
				::SendMessage(hWndChild, uMsg, wParam, lParam);
			return false;
		}
		return false;
	}
};

} // namespace ketchup
