#pragma once

#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

struct chain_client_commands
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		if (uMsg == WM_COMMAND)
		{
			HWND hWnd = derived.m_hWndClient;
			if (hWnd != NULL)
				::SendMessage(hWnd, uMsg, wParam, lParam);
			return false;
		}

		return false;
	}
};

} // namespace ketchup
