#pragma once

#include <cassert>
#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

struct assert_entry
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		assert(false);
		return false;
	}
};

} // namespace ketchup
