#pragma once

#include "update_cmd_ui_message.hpp"
#include "impl/menu_cmd_ui.hpp"
#include "impl/toolbar_cmd_ui.hpp"
#include "impl/childwindow_cmd_ui.hpp"
#include "impl/multipanestatusbar_cmd_ui.hpp"

namespace ketchup
{

///////////////////////////////////////////////////////////////////////////////
// update_cmd_ui
//  throws the cmd_ui to window
//
bool update_cmd_ui(HWND hWndUpdater, cmd_ui& ui)
{
	CWindow wnd(hWndUpdater);
	assert(wnd.IsWindow());
	cmd_ui* p_cmd_ui = &ui;
	return is_cmd_ui_handled_by_window(
		wnd.SendMessage(update_cmd_ui_message_id(), reinterpret_cast<WPARAM>(p_cmd_ui))
	);
}

///////////////////////////////////////////////////////////////////////////////
// update_toolbar_cmd_ui
//
void update_toolbar_cmd_ui(HWND hWndUpdater, HWND hWndToolBar)
{
	// See: MFC7::CToolBar::OnUpdateCmdUI
	CToolBarCtrl wndToolBar(hWndToolBar);
	assert(wndToolBar.IsWindow());

	int nIndexMax = wndToolBar.GetButtonCount();
	for (int i = 0; i < nIndexMax; ++i)
	{
		// get buttons state
		TBBUTTON button;
		wndToolBar.GetButton(i, &button);
		UINT nID = button.idCommand;
		toolbar_cmd_ui ui(nID, wndToolBar);

		// ignore separators
		if (!(button.fsStyle & TBSTYLE_SEP))
			update_cmd_ui(hWndUpdater, ui);
	}
}

///////////////////////////////////////////////////////////////////////////////
// update_menu_cmd_ui
//
void update_menu_cmd_ui(HWND hWndUpdater, HMENU hMenu)
{
	// See: MFC7::CFrameWnd::OnInitMenuPopup
	CMenuHandle menu(hMenu);
	assert(menu.IsMenu());

	int count = menu.GetMenuItemCount();
	for (int i = 0; i < count; ++i)
	{
		UINT nID = menu.GetMenuItemID(i);
		if (nID == 0)
			continue; // menu separator or invalid cmd - ignore it

		if (nID == (UINT)-1)
		{
			// possibly a popup menu, route to first item of that popup
			CMenuHandle sub_menu = menu.GetSubMenu(i);
			if (sub_menu.m_hMenu == NULL ||
				(nID = sub_menu.GetMenuItemID(0)) == 0 ||
				nID == (UINT)-1)
			{
				continue;       // first item of popup can't be routed to
			}
			menu_cmd_ui ui(nID, menu, i, true);
			update_cmd_ui(hWndUpdater, ui); // popups
		}
		else
		{
			// normal menu item
			menu_cmd_ui ui(nID, menu, i, false);
			update_cmd_ui(hWndUpdater, ui);
		}

		// adjust for menu deletions and additions
		int new_count = menu.GetMenuItemCount();
		if (new_count < count)
		{
			i -= (count - new_count);
			while (i < new_count &&
				menu.GetMenuItemID(i) == nID)
			{
				++i;
			}
		}
		count = new_count;
	} // for
}

///////////////////////////////////////////////////////////////////////////////
// update_menubar_cmd_ui
//
// who needs?

///////////////////////////////////////////////////////////////////////////////
// update_commandbar_cmd_ui
//
// who needs?

///////////////////////////////////////////////////////////////////////////////
// update_childwindow_cmd_ui
//
void update_childwindow_cmd_ui(HWND hWndUpdater, HWND hWndParent, UINT nID)
{
	CWindow wndParent(hWndParent);
	assert(wndParent.IsWindow());
	CWindow wndChild = wndParent.GetDlgItem(nID);
	assert(wndChild.IsWindow());
	childwindow_cmd_ui ui(nID, wndChild);
	update_cmd_ui(hWndUpdater, ui);
}

///////////////////////////////////////////////////////////////////////////////
// update_multipanestatusbar_cmd_ui
//
template< class MultiPaneStatusBarCtrl >
void update_multipanestatusbar_cmd_ui(HWND hWndUpdater, MultiPaneStatusBarCtrl& wndStatusBar)
{
	assert(wndStatusBar.IsWindow());

	int nIndexMax = wndStatusBar.m_nPanes;
	for (int i = 0; i < nIndexMax; ++i)
	{
		// get buttons state
		int nID = wndStatusBar.m_pPane[i];
		multipanestatusbar_cmd_ui<MultiPaneStatusBarCtrl> ui(nID, wndStatusBar, i);
		update_cmd_ui(hWndUpdater, ui);
	}
}

} // namespace ketchup
