
#pragma once

#include "../cmd_ui.hpp"

namespace ketchup
{

///////////////////////////////////////////////////////////////////////////////
// multipanestatusbar_cmd_ui
// Note:
//  default win32-pane-architecture missing pane-sensitive id
//
template< class MultiPaneStatusBarCtrl >
struct multipanestatusbar_cmd_ui : cmd_ui
{
	MultiPaneStatusBarCtrl& m_wndStatusBar;
	int m_nIndex;

	explicit multipanestatusbar_cmd_ui(UINT nPaneID, MultiPaneStatusBarCtrl& wnd, int nIndex)
		: cmd_ui(nPaneID), m_wndStatusBar(wnd), m_nIndex(nIndex)
	{
		assert(m_wndStatusBar.IsWindow());
	}

	virtual void set_check(int nCheck = 1)
	{
		ATL::CString str;
		int nOldStyle = 0;
		m_wndStatusBar.GetText(m_nIndex, str, &nOldStyle);

		int nNewStyle = nOldStyle & ~SBT_POPOUT;
		if (nCheck != 0)
			nNewStyle |= SBT_POPOUT;

		m_wndStatusBar.SetText(m_nIndex, str, nNewStyle);
	}

	virtual void set_text(LPCTSTR lpstrText)
	{
		m_wndStatusBar.SetPaneText(get_id(), lpstrText);
	}
};

} // namespace ketchup
