
#pragma once

#include <cassert>
#include "../cmd_ui.hpp"
#include "../utility/init_cbSize.hpp"

namespace ketchup
{

///////////////////////////////////////////////////////////////////////////////
// menu_cmd_ui
//
struct menu_cmd_ui : cmd_ui
{
private:
	CMenuHandle m_menu;
	UINT m_nIndex;
	bool m_clingy;

public:
	HMENU get_menu() const { return m_menu; }
	UINT get_index() const { return m_nIndex; }

	explicit menu_cmd_ui(UINT nID, HMENU hMenu, UINT nIndex, bool clingy)
		: cmd_ui(nID), m_menu(hMenu), m_nIndex(nIndex), m_clingy(clingy)
	{
		assert(m_menu.IsMenu());
	}

	virtual void enable(bool bOn = true)
	{
		m_menu.EnableMenuItem(m_nIndex, MF_BYPOSITION |
			(bOn ? MF_ENABLED : (MF_DISABLED | MF_GRAYED)));
	}

	virtual void set_check(int nCheck = 1)
	{
		m_menu.CheckMenuItem(m_nIndex, MF_BYPOSITION |
			(nCheck ? MF_CHECKED : MF_UNCHECKED));
	}

	virtual void set_text(LPCTSTR lpszText)
	{
		assert(lpszText != NULL);
		// get current menu state so it doesn't change
		UINT nState = m_menu.GetMenuState(m_nIndex, MF_BYPOSITION);
		nState &= ~(MF_BITMAP|MF_OWNERDRAW|MF_SEPARATOR);

		// set menu text
		utility::init_cbSize<MENUITEMINFO>::type mii;
		mii.fMask = MIIM_ID;
		ATLVERIFY(m_menu.GetMenuItemInfo(m_nIndex, TRUE, &mii));
		ATLVERIFY(m_menu.ModifyMenu(m_nIndex, MF_BYPOSITION |
			MF_STRING | nState, mii.wID, lpszText));
	}

	virtual void set_default(bool bOn = true)
	{
		// place checkmark next to menu item
		if (bOn)
			m_menu.SetMenuDefaultItem(m_nIndex, TRUE);
	}

	virtual bool is_clingy()
	{
		return m_clingy;
	}
};

} // namespace ketchup
