#pragma once

#include "../update_cmd_ui.hpp"
#include "../update_cmd_ui_message.hpp"
#include "../../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

struct menu_cmd_ui_generator
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		if (uMsg == WM_INITMENUPOPUP)
		{
			update_menu_cmd_ui(hWnd, (HMENU)wParam);
		}
		return false;
	}
};

} // namespace ketchup
