#pragma once

#include "../cmd_ui.hpp"
#include "../update_cmd_ui_message.hpp"
#include "../../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

template< class Entry, class EnableIDs >
struct cmd_ui_auto_enable
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		if (uMsg == update_cmd_ui_message_id())
		{
			bool b_cmd_ui_handled = Entry::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);
			cmd_ui& cmd_ui = get_cmd_ui_from_wParam(wParam);
			if (EnableIDs::includes(cmd_ui.get_id())) {
				cmd_ui.enable(b_cmd_ui_handled);
			}
			return b_cmd_ui_handled;
		}

		return false;
	}
};

} // namespace ketchup
