#pragma once

#include "../update_cmd_ui_message.hpp"
#include "../../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

struct chain_client_cmd_ui
{
	template< class Derived >
	static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
	{
		ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

		if (uMsg == update_cmd_ui_message_id())
		{
			HWND hWnd = derived.m_hWndClient;
			if (hWnd != NULL) {
				BOOL bHandled = (BOOL)::SendMessage(hWnd, uMsg, wParam, lParam);
				lResult = bHandled;
				return bHandled == TRUE;
			}
		}
		return false;
	}
};

} // namespace ketchup
