#pragma once

#include "cmd_ui.hpp"
#include "update_cmd_ui.hpp"
#include "update_cmd_ui_message.hpp"
#include "../utility/ignore_unused_variables_warning.hpp"

namespace ketchup
{

template< class Derived >
struct cmd_ui_handler_entry_set
{

	///////////////////////////////////////////////////////////////////////////////
	// cmd_ui_handler
	//
	template<
		UINT nID,
		void (Derived::*func)(cmd_ui&)
	>
	struct cmd_ui_handler
	{
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == update_cmd_ui_message_id())
			{
				cmd_ui& ui = get_cmd_ui_from_wParam(wParam);
				if (ui.get_id() == nID)
				{
					(derived.*func)(ui);
					lResult = TRUE;		// That's it!
					return true;			// make lResult alive!
				}
			}

			return false;
		}
	};

	template<
		UINT nID,
		void (Derived::*func)(cmd_ui&)
	>
	struct cmd_ui_handler_not_handled
	{
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == update_cmd_ui_message_id())
			{
				cmd_ui& ui = get_cmd_ui_from_wParam(wParam);
				if (ui.get_id() == nID)
				{
					(derived.*func)(ui);
				}
			}

			return false;
		}
	};

}; // cmd_ui_handler_entry_set

} // namespace ketchup
