#pragma once

namespace ketchup
{

struct aux_cmd_ui_entry_set
{

	struct chain_client_cmd_ui
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == update_cmd_ui_message_id())
			{
				HWND hWnd = derived.m_hWndClient;
				if (hWnd != NULL) {
					BOOL bHandled = (BOOL)::SendMessage(hWnd, uMsg, wParam, lParam);
					lResult = bHandled;
					return bHandled == TRUE;
				}
			}
			return false;
		}
	};

	struct chain_mdi_child_cmd_ui
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == update_cmd_ui_message_id())
			{
				HWND hWnd = derived.MDIGetActive();
				if (hWnd != NULL) {
					BOOL bHandled = (BOOL)::SendMessage(hWnd, uMsg, wParam, lParam);
					lResult = bHandled;
					return bHandled == TRUE;
				} 
			}
			return false;
		}
	};

	template< class Entry, class EnableIDs >
	struct cmd_ui_enable_if_handled
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == update_cmd_ui_message_id())
			{
				bool b_cmd_ui_handled = Entry::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);
				cmd_ui& cmd_ui = get_cmd_ui_from_wParam(wParam);
				if (EnableIDs::includes(cmd_ui.get_id())) {
					cmd_ui.enable(b_cmd_ui_handled);
				}
				return b_cmd_ui_handled;
			}

			return false;
		}
	};

	struct cmd_ui_update_menu
	{
		template< class Derived >
		static bool process(Derived& derived, HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID)
		{
			ignore_unused_variables_warning(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID);

			if (uMsg == WM_INITMENUPOPUP)
			{
				update_menu_cmd_ui(hWnd, (HMENU)wParam);
			}
			return false;
		}
	};

}; // struct aux_cmd_ui_entry_set

} // namespace ketchup
