
#pragma once

#include "../cmd_ui.hpp"
#include "../update_cmd_ui.hpp"
#include "../ignore_unused_variables_warning.hpp"

namespace ketchup { namespace handler {

template< class Derived >
struct cmd_ui_handlers
{
	///////////////////////////////////////////////////////////////////////////////
	// cmd_ui_handler
	//
	template< UINT nID, void (Derived::*func)(cmd_ui&) >
	struct cmd_ui_handler
	{
		static bool process(KETCHUP_process_params)
		{
			ignore_unused_variables_warning(KETCHUP_process_args);

			if (uMsg == update_cmd_ui_message_id())
			{
				cmd_ui& ui = get_cmd_ui_from_wParam(wParam);
				if (ui.get_id() == nID) {
					bHandled = TRUE;
					(derived.*func)(ui);
					if (bHandled) {
						lResult = TRUE;	// That's it!
						return true;											// make lResult alive!
					}
				}
			}
			return false;
		}
	};

	///////////////////////////////////////////////////////////////////////////////
	// chain_client_cmd_ui
	//
	struct chain_client_cmd_ui
	{
		static bool process(KETCHUP_process_params)
		{
			ignore_unused_variables_warning(KETCHUP_process_args);

			if (uMsg == update_cmd_ui_message_id())
			{
				HWND hWnd = derived.m_hWndClient;
				if (hWnd != NULL) {
					BOOL bHandled = (BOOL)::SendMessage(hWnd, uMsg, wParam, lParam);
          lResult = bHandled;
					return bHandled == TRUE;
				}
			}
			return false;
		}
	};
	///////////////////////////////////////////////////////////////////////////////
	// chain_client_cmd_ui
	//
	struct chain_mdi_child_cmd_ui
	{
		static bool process(KETCHUP_process_params)
		{
			ignore_unused_variables_warning(KETCHUP_process_args);

			if (uMsg == update_cmd_ui_message_id())
			{
				HWND hWnd = derived.MDIGetActive();
				if (hWnd != NULL) {
					BOOL bHandled = (BOOL)::SendMessage(hWnd, uMsg, wParam, lParam);
          lResult = bHandled;
					return bHandled == TRUE;
				} 
			}
			return false;
		}
	};

	///////////////////////////////////////////////////////////////////////////////
	// menu_cmd_ui_generator
	//
	struct menu_cmd_ui_generator
	{
		static bool process(KETCHUP_process_params)
		{
			ignore_unused_variables_warning(KETCHUP_process_args);

			if (uMsg == WM_INITMENUPOPUP)
			{
				update_menu_cmd_ui(hWnd, (HMENU)wParam);
			}
			return false;
		}
	};

	///////////////////////////////////////////////////////////////////////////////
	// cmd_ui_handler_auto_enable
	//
	template< class EnableIDs, class Entry >
	struct cmd_ui_handler_auto_enable
	{
		static bool process(KETCHUP_process_params)
		{

			if (uMsg == update_cmd_ui_message_id())
			{
				bool b_cmd_ui_handled = Entry::process(KETCHUP_process_args);
				cmd_ui& cmd_ui = get_cmd_ui_from_wParam(wParam);
				if (EnableIDs::includes(cmd_ui.get_id())) {
					cmd_ui.enable(b_cmd_ui_handled);
				}
				return b_cmd_ui_handled;
			}

			return false;
		}
	};
};

} } // namespace ketchup::handler
