
#ifndef BOOST_PP_IS_ITERATING

	#ifndef KETCHUP_CMD_UI_IDS_INCLUDED
		#define KETCHUP_CMD_UI_IDS_INCLUDED

		#include <boost/preprocessor/arithmetic/sub.hpp>
		#include <boost/preprocessor/cat.hpp>
		#include <boost/preprocessor/comparison/equal.hpp>
		#include <boost/preprocessor/facilities/identity.hpp>
		#include <boost/preprocessor/iteration/iterate.hpp>
		#include <boost/preprocessor/iteration/local.hpp>
		#include <boost/preprocessor/repetition/enum_params.hpp>
		#include <boost/preprocessor/repetition/enum_params_with_a_default.hpp>
		#include <boost/preprocessor/repetition/repeat.hpp>
		#include <boost/preprocessor/stringize.hpp>

		#ifndef KETCHUP_LIMIT_CMD_UI_IDS_SIZE
			#define KETCHUP_LIMIT_CMD_UI_IDS_SIZE 30
		#endif
		
		// local macro
		#define KETCHUP_cm_ui_ids_statement(z, i, unused) \
		if (ID##i == id) \
		{ \
			return true; \
		} \
		/**/

		// header
		BOOST_PP_IDENTITY(#pragma once)()

		namespace ketchup {

// primary
template<
	BOOST_PP_ENUM_PARAMS_WITH_A_DEFAULT(KETCHUP_LIMIT_CMD_UI_IDS_SIZE, UINT ID, 0)
>
struct cmd_ui_ids
{
	static bool includes(UINT id)
	{
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_cm_ui_ids_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, KETCHUP_LIMIT_CMD_UI_IDS_SIZE-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};

// empty
template<
>
struct cmd_ui_ids<
>
{
	static bool includes(UINT)
	{
		return false;
	}
};


		#define BOOST_PP_ITERATION_LIMITS(1, KETCHUP_LIMIT_CMD_UI_IDS_SIZE-1)
		#define BOOST_PP_FILENAME_1 "cmd_ui_ids.hpp"
		#include BOOST_PP_ITERATE()

		// clean up

		} // namespace ketchup
		
		#undef KETCHUP_message_map_statement

	#endif // KETCHUP_CMD_UI_IDS_INCLUDED

#else // BOOST_PP_IS_ITERATING

	#define n BOOST_PP_ITERATION()


template<
	BOOST_PP_ENUM_PARAMS(n, UINT ID)
>
struct cmd_ui_ids<
	BOOST_PP_ENUM_PARAMS(n, ID)
>
{
	static bool includes(UINT id)
	{
		#define BOOST_PP_LOCAL_MACRO(n) KETCHUP_cm_ui_ids_statement(~, n, ~)
		#define BOOST_PP_LOCAL_LIMITS (0, n-1)
		#include BOOST_PP_LOCAL_ITERATE()
		#undef BOOST_PP_LOCAL_MACRO

		return false;
	}
};


	#undef n

#endif // BOOST_PP_IS_ITERATING
