#pragma once
///////////////////////////////////////////////////////////////////////////////
// ketchup/detail/gen_message_processor_base.hpp
//
#include <boost/mpl/eval_if.hpp>
#include <boost/mpl/placeholders.hpp>
#include <boost/mpl/reverse_fold.hpp>
#include "../ignore_unused_variables_warning.hpp"

namespace ketchup { namespace detail {
	
///////////////////////////////////////////////////////////////////////////////
// Note:
//  If MessageMap has same Entries, VC7.1 duplicates
//  the static member function, Entry::process (LNK1179 error).
//  I can't understand the problem,
//  but VC7.1 seems to hate static member functions.
//  So I define fold_op_workaround and...
//
// process_entry
//
template< class Derived, class Entry >
bool process_entry(KETCHUP_process_params)
{
	return Entry::process(KETCHUP_process_args);
}

struct base_for_cracked_handlers
{
	bool b_msg_handled;
	bool is_msg_handled() { return b_msg_handled; }
	void set_msg_handled(bool b_) { b_msg_handled = b_; }	
};

///////////////////////////////////////////////////////////////////////////////
// gen_message_processor_base
//
template< class Derived >
struct gen_message_processor_base : base_for_cracked_handlers
{
	struct fold_init_state
	{
		static bool process(KETCHUP_process_params)
		{
			ignore_unused_variables_warning(KETCHUP_process_args);
			return false;
		}
	};
	
	// The placeholders say mpl_assert_not_arg, so I define
	struct fold_op_workaround
	{
		template< class State, class Entry >
		struct apply
		{
			static bool process(KETCHUP_process_params)
			{
				if (detail::process_entry<Derived, Entry>(KETCHUP_process_args))
					return true;
				else
					return State::process(KETCHUP_process_args);
			}

			typedef apply type;
		};
	};

	template< class MessageMap >
	BOOL process_window_message(HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam, LRESULT& lResult, DWORD dwMsgMapID = 0)
	{
		typedef typename boost::mpl::reverse_fold<MessageMap,
			fold_init_state,
			fold_op_workaround
		>::type statement;

		Derived& derived = *static_cast<Derived*>(this);
		BOOL bHandled = TRUE;
		bool old = derived.is_msg_handled(); // for recursive calls
		BOOL ret = statement::process(derived, hWnd, uMsg, wParam, lParam, lResult, dwMsgMapID, bHandled) ? TRUE : FALSE;
		derived.set_msg_handled(old);
		return ret;
	}
	
	typedef gen_message_processor_base type;
};

} } // namespace ketchup::detail
