#pragma once

#include "prelude.hpp"
#include "epsilon.hpp"

namespace biscuit
{

template<
	class Parser0 = epsilon, class Parser1 = epsilon,
	class Parser2 = epsilon, class Parser3 = epsilon,
	class Parser4 = epsilon, class Parser5 = epsilon,
	class Parser6 = epsilon, class Parser7 = epsilon,
	class Parser8 = epsilon, class Parser9 = epsilon
>
struct sequence
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;
		
		if (
			Parser0::parse(state)
			&& Parser1::parse(state)
			&& Parser2::parse(state)
			&& Parser3::parse(state)
			&& Parser4::parse(state)
			&& Parser5::parse(state)
			&& Parser6::parse(state)
			&& Parser7::parse(state)
			&& Parser8::parse(state)
			&& Parser9::parse(state)
		)
		{
			return true;
		}
		else
		{
			state.cur = tmp;
			return false;
		}
	}
};

} // namespace biscuit
