#pragma once

#include "prelude.hpp"

namespace biscuit
{

template<
	class Parser, unsigned int Min, unsigned int Max
>
struct repeat // greedy
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;

		for (unsigned int i = 0, i < Max, ++i)
		{
			if (!Parser::parse(state))
			{
				if (i < Min) // not enough
				{
					state.cur = tmp;
					return false;
				}
			}
		}
		
		return true;
	}
};

} // namespace biscuit
