#pragma once

#include "prelude.hpp"

namespace biscuit
{

template< wchar_t MinCh, wchar_t MaxCh>
struct wchar_t_range
{
	template< class State >
	static bool parse(State &state)
	{
		if (eos(state))
			return false;

		if (MinCh <= *state.cur && *state.cur <= MaxCh)
		{
			++state.cur;
			return true;
		}

		return false;
	}
};

} // namespace biscuit
