#pragma once

#include "prelude.hpp"

namespace biscuit
{

template< char MinCh, char MaxCh>
struct char_range
{
	template< class State >
	static bool parse(State &state)
	{
		if (eos(state))
			return false;

		if (MinCh <= *state.cur && *state.cur <= MaxCh)
		{
			++state.cur;
			return true;
		}

		return false;
	}
};

} // namespace biscuit
