#pragma once

#include "prelude.hpp"

namespace biscuit
{

template< char Ch >
struct char_
{
	template< class State >
	static bool parse(State &state)
	{
		if (eos(state))
			return false;

		if (Ch == *state.cur)
		{
			++state.cur;
			return true;
		}

		return false;
	}
};

} // namespace biscuit
