#pragma once

#include "prelude.hpp"
#include "begin.hpp"
#include "end.hpp"
#include "epsilon.hpp"

namespace biscuit
{

template<
	class ParserA, class ParserB
>
struct kleene_star_until // -*A >> B
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;

		while (!ParserB::parse(state))
		{
			if (!ParserA::parse(state))
			{
				state.cur = tmp;
				return false;
			}
		}

		return true;
	}
	
	typedef kleene_star_until type;
};

// meaningless
template< class ParserB >
struct kleene_star_until<begin, ParserB>;

template< class ParserB >
struct kleene_star_until<end, ParserB>;

template< class ParserB >
struct kleene_star_until<epsilon, ParserB>;

} // namespace biscuit
