#pragma once

#include "prelude.hpp"

namespace biscuit
{

template<
	class ParserA, class ParserB
>
struct intersection
{
	template< class State >
	static bool parse(State &state)
	{
		typename State::iterator_type const tmp = state.cur;
		if (ParserA::parse(state))
		{
			state.cur = tmp;
			return ParserB::parse(state);
		}
		
		return false;
	}
};

} // namespace biscuit
